---
title: Installation
editLink: true
---

# Installation
Getting started with ProIcons doesn't take long. Follow the steps below for your environment:

- [HTML](#html)
- [HTML Webfont](#html-webfont)
- [Node.js](#nodejs)
- [React](#react)
- [Svelte](#svelte)
- [Vue](#vue)

## HTML
<!-- #region install-html -->
### Using a CDN provider

#### [JSDelivr/esm.run](https://www.jsdelivr.com)
Import `proicons` via [esm.run](https://esm.run) in a JavaScript module

```javascript
import * as proicons from 'https://esm.run/proicons'
// or 'https://cdn.jsdelivr.net/npm/proicons/+esm'
```

#### [UNPKG](https://unpkg.com)
Import `proicons` via UNPKG using a `<script>` tag in your HTML
```html
<script src="https://unpkg.com/proicons"></script>
```

### Install locally

If you want to use ProIcons locally, you can also install ProIcons via [NPM](https://npmjs.com/package/proicons).

<!-- #region install-general -->
::: code-group

```shell [NPM]
npm install proicons
```

```shell [Yarn]
yarn add proicons
```

```shell [PNPM]
pnpm add proicons
```

```shell [Bun]
bun add proicons
```

:::
<!-- #endregion install-general -->

Then import your `proicons.js` file in your HTML
```html
<script src="path/to/proicons/dist/umd/proicons.cjs"></script>
``` 
Replace `path/to/` with the actual path to your `node_modules` folder (relative to the HTML file).
<!-- #endregion install-html -->
## Node.js
<!-- #region install-node -->
Install ProIcons from NPM:

<!--@include: ./installation.md#install-general-->

```javascript
import { AddIcon } from 'proicons';
```
Or in CommonJS:
```javascript
const proicons = require('proicons');
const { AddIcon } = proicons
```
<!-- #endregion install-node -->
## HTML Webfont
If you prefer not to use any scripts, you can also install ProIcons as a webfont on your site.

<!-- @include: ../packages/webfont.md#install-webfont -->

[Read the documentation](webfont)

## React
<!-- @include: ../packages/react.md#install-react -->

[Read the documentation](react)

## Svelte
<!-- @include: ../packages/svelte.md#install-svelte -->

[Read the documentation](svelte)

## Vue
<!-- @include: ../packages/vue.md#install-vue -->

[Read the documentation](vue)