---
title: What is ProIcons?
editLink: true
---

# What is ProIcons

ProIcons is an open-source icon library of over 500+ icons, free for anyone to use in their project.

## Icons

The entire list of icons in the set is available [here](../icons).

Can't find the icon you wanted? You can always request an icon or add your own icon on [GitHub](https://github.com/ProCode-Software/proicons).

### Icon Design

ProIcons are designed to be modern, friendly, and consistent. Icons are designed on a 24x24px grid, with 1.5px strokes.

You can learn more about icon design and how to design your own icons for ProIcons [here](design-guidelines/).

## Packages & Libraries

ProIcons is currently available for [HTML](html-api), [Node.js/Vanilla JS](javascript-api), [React](react), [Svelte](svelte), and [Vue](vue).

## Developer Experience

ProIcons is built to be simple and easy for developers to use. We have added quality-of-life features to our packages including:

- **Typings and IDE autocompletion:** Type declarations and code-completion for icon names available in all packages so you don't have to remember the icon names.
- **IDE Icon previews:** We have also included icon previews in IntelliSense for all icons.
- **Support for several frameworks:** First-class support for the most popular JavaScript frameworks.
- **Tree-shakability:** Include ProIcons in your app without having to sacrifice on performance or disk space.

### Tree-shaking

ProIcons libraries are compatible with ESM [tree-shaking](https://en.wikipedia.org/wiki/Tree_shaking). This allows you to bundle only the icons you need, rather than the entire set, when using a module bundler such as [Webpack](https://webpack.js.org) or [Rollup](https://rollupjs.org). This becomes more important for performance as the icon set gets bigger.

## Roadmap

ProIcons is still a work in progress with new features and libraries coming soon. Learn more [here](roadmap).

## License

The ProIcons library is MIT-licensed, giving you the freedom to use, share, modify and distribute the library for personal and commercial use. Learn more [here](https://github.com/ProCode-Software/proicons/?tab=MIT-1-ov-file).
