---
title: How to contribute
---

# How to contribute

✨ First off, thanks for taking the time to contribute! ✨

The following is a quick set of guidelines for contributing to Iconoir.

## Pull Requests

> **ℹ️ Note:** At the moment, to keep consistency, quality, and make the whole
> process time-efficient, we are not accepting pull requests containing icons. You can open an issue
> to request a new icon.

Pull requests for new features, bug fixes, etc. are often appreciated.

> 👉 We're looking for help with fonts and libraries.

Guidelines for pull requests:

> **Make your commit messages as descriptive as possible.** Include as much information as you can.
> Explain anything that the file diffs themselves won't make apparent.

> **Target main.** Most of bugfixes or new features should go to the main branch.

> **Include only related work.** If your pull request has unrelated commits, it won't be accepted.

> **Packages and Libraries.** If you're adding or updating a package or React / Vue library, the
> target folder is `/packages/iconoir-[LIBRARY_NAME]`.

> **Fonts.** If you're adding or updating fonts, the target folder is `/fonts/`.

## Icon Requests

Before creating an icon request, please search to see if someone has requested the icon already. If
there is an open request, please upvote it.

If the icon has not already been requested, [create an
issue](https://github.com/iconoir-icons/iconoir/issues/new/choose) and add as much information as
possible. Follow the rules you see when opening a new bug report.

## Bug Reports

Before reporting an issue, please search to see if someone has filed a similar issue before. If
there is already an open issue, please upvote it and/or leave a comment with additional information.
Follow the rules you see when opening a new bug report.
