/**
 * Copyright IBM Corp. 2020, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * The alignment choices of popover.
 */
export enum POPOVER_ALIGNMENT {
  /**
   * Align the top position for the popover content.
   */
  TOP = 'top',

  /**
   * Align the top-left position for the popover content.
   *
   * @deprecated
   */
  TOP_LEFT = 'top-left',

  /**
   * Align the top right position for the popover content.
   *
   * @deprecated
   */
  TOP_RIGHT = 'top-right',

  /**
   * Align the top-start position for the popover content.
   */
  TOP_START = 'top-start',

  /**
   * Align the top end position for the popover content.
   */
  TOP_END = 'top-end',

  /**
   * Align the bottom position for the popover content.
   */
  BOTTOM = 'bottom',

  /**
   * Align the bottom left position for the popover content.
   *
   * @deprecated
   */
  BOTTOM_LEFT = 'bottom-left',

  /**
   * Align the bottom right position for the popover content.
   *
   * @deprecated
   */
  BOTTOM_RIGHT = 'bottom-right',

  /**
   * Align the bottom start position for the popover content.
   */
  BOTTOM_START = 'bottom-start',

  /**
   * Align the bottom end position for the popover content.
   */
  BOTTOM_END = 'bottom-end',

  /**
   * Align the left position for the popover content.
   */
  LEFT = 'left',

  /**
   * Align the left bottom position for the popover content.
   *
   * @deprecated
   */
  LEFT_BOTTOM = 'left-bottom',

  /**
   * Align the left top position for the popover content.
   *
   * @deprecated
   */
  LEFT_TOP = 'left-top',

  /**
   * Align the left start position for the popover content.
   */
  LEFT_START = 'left-start',

  /**
   * Align the left end position for the popover content.
   */
  LEFT_END = 'left-end',

  /**
   * Align the right position for the popover content.
   */
  RIGHT = 'right',

  /**
   * Align the right bottom position for the popover content.
   *
   * @deprecated
   */
  RIGHT_BOTTOM = 'right-bottom',

  /**
   * Align the right top position for the popover content.
   *
   * @deprecated
   */
  RIGHT_TOP = 'right-top',

  /**
   * Align the right start position for the popover content.
   */
  RIGHT_START = 'right-start',

  /**
   * Align the right end position for the popover content.
   */
  RIGHT_END = 'right-end',
}

/**
 * The background token options for popover.
 */
export enum POPOVER_BACKGROUND_TOKEN {
  /**
   * Use the layer token for the background.
   */
  LAYER = 'layer',

  /**
   * Use the background token for the background.
   */
  BACKGROUND = 'background',
}
