/**
 * Copyright IBM Corp. 2018, 2026
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

export const defaultAttributes = {
  // Reference:
  // https://github.com/IBM/carbon-components-react/issues/1392
  // https://github.com/PolymerElements/iron-iconset-svg/pull/47
  // `focusable` is a string attribute which is why we do not use a boolean here
  focusable: 'false',
  preserveAspectRatio: 'xMidYMid meet',
};

/**
 * Get supplementary HTML attributes for a given <svg> element based on existing
 * attributes.
 */
export default function getAttributes({
  width,
  height,
  viewBox = `0 0 ${width} ${height}`,
  ...attributes
}: Record<string, unknown> = {}): Record<string, unknown> {
  const { tabindex, ...rest } = attributes;
  const iconAttributes: Record<string, unknown> = {
    ...defaultAttributes,
    ...rest,
    width,
    height,
    viewBox,
  };

  if (iconAttributes['aria-label'] || iconAttributes['aria-labelledby']) {
    iconAttributes.role = 'img';

    // Reference:
    // https://allyjs.io/tutorials/focusing-in-svg.html
    if (tabindex !== undefined && tabindex !== null) {
      iconAttributes.focusable = 'true';
      iconAttributes.tabindex = tabindex;
    }
  } else {
    iconAttributes['aria-hidden'] = true;
  }

  return iconAttributes;
}
