# v11

This document outlines all of the changes to the Carbon Design System from v10
to v11. If you're just starting, check out our
[migration site](https://carbondesignsystem.com/migrating/guide/overview).

If you're looking for migration information for a specific package, use the list
of packages below.

- [carbon-components](#carbon-components)
- [carbon-components-react](#carbon-components-react)
- [carbon-icons](#carbon-icons)
- [@carbon/icons](#carbonicons)
- [@carbon/icons-react](#carbonicons-react)
- [@carbon/colors](#carboncolors)
- [@carbon/elements](#carbonelements)
- [@carbon/grid](#carbongrid)
- [@carbon/layout](#carbonlayout)
- [@carbon/motion](#carbonmotion)
- [@carbon/themes](#carbonthemes)
- [@carbon/type](#carbontype)

Carbon also provides codemods through the
[`@carbon/upgrade`](../../packages/upgrade/README.md) package to help with
migration.

## carbon-components

`carbon-components` reached it's end of support on September 30, 2024. This
package will no longer receive updates.

`carbon-components` is replaced by `@carbon/styles`, but most projects don't
need to install `@carbon/styles` directly.

If you're using `@carbon/react` or `@carbon/web-components`, you do not need to
install `@carbon/styles`. All `@carbon/styles` assets are already available to
you through those framework-specific packages.

Library authors should use `@carbon/styles` if they do not already rely on a
framework-variant package such as `@carbon/react`.

### Changing from `node-sass` to `sass`

The styles of Carbon have been completely updated to use
[Sass Modules](https://css-tricks.com/introducing-sass-modules/). This change
requires that teams use the [Dart Sass](https://npmjs.com/package/sass) package.
Support for `node-sass` has been dropped starting in v11.

This decision was made after seeing the
[deprecation notice](https://sass-lang.com/blog/libsass-is-deprecated) of
LibSass in late 2020.

### Changing import paths from `scss/globals/scss` to `scss`

With this change to Sass Modules, you'll find that many ways you use Carbon
today have been updated and streamlined. In general, most paths have changed
from the long form `scss/globals/scss/path/to/file` to `scss/path/to/file`.

For example, to access the `theme` entry point, import `scss/globals/scss/theme`
in v10. Now, this entry point lives at `scss/theme`.

Alongside the updates to filepaths, you will find that helper mixins, functions,
and variables have been updated to no longer have a `carbon--` prefix. With Sass
Modules: the module name now serves as an appropriate prefix and provides
scoping for variables, mixins, and functions. The prefix `carbon--` can be
easily removed by performing a basic find and replace operation, as illustrated
in the following example.

```diff
- @include carbon--breakpoint(lg) {
+ @include breakpoint(lg) {
      width: 42%;
  }
```

There are two major areas of change in the package, namely:

- [`scss/globals/scss`](#scssglobalsscss)
- [`scss/components/`](#scsscomponents)

### scss/globals/scss

The majority of the files currently available under `/scss/globals/scss` are now
available directly under the `scss` directory or through our new utilities
folder in `scss/utilities`.

Below, you'll find an overview of files that are a part of our Public API and
where they have moved to in v11. Each row also contains a link to a section
below that reviews any API changes for the file.

| File                                                                            | v11                                                                       |
| ------------------------------------------------------------------------------- | ------------------------------------------------------------------------- |
| [`scss/globals/scss/styles.scss`](#scssglobalsscssstylesscss)                   | Moved to `index.scss` in `@carbon/styles`                                 |
| [`scss/globals/grid/_grid.scss`](#scssglobalsgrid_gridscss)                     | Moved to `scss/_grid.scss`                                                |
| [`scss/globals/scss/_colors.scss`](#scssglobalsscss_colorsscss)                 | Moved to `scss/_colors.scss`                                              |
| `scss/globals/scss/_css--body.scss`                                             | Removed, most of these styles are available through the CSS reset         |
| [`scss/globals/scss/_css--font-face.scss`](#scssglobalsscss_css--font-facescss) | Moved to `scss/fonts`                                                     |
| [`scss/globals/scss/_css--helpers.scss`](#scssglobalsscss_css--helpersscss)     | Moved to `scss/utilities/`                                                |
| [`scss/globals/scss/_css--reset.scss`](#scssglobalsscss_css--resetscss)         | Moved to `scss/_reset.scss`                                               |
| [`scss/globals/scss/_helper-classes.scss`](#scssglobalsscss_helper-classesscss) | Moved to `scss/utilities/`                                                |
| [`scss/globals/scss/_helper-mixins.scss`](#scssglobalsscss_helper-mixinsscss)   | Moved to `scss/utilities/`                                                |
| `scss/globals/scss/_import-once.scss`                                           | Removed                                                                   |
| `scss/globals/scss/_layer.scss`                                                 | Removed                                                                   |
| [`scss/globals/scss/_layout.scss`](#scssglobalsscss_layoutscss)                 | This file has been split into `scss/spacing` and `scss/utilities/z-index` |
| [`scss/globals/scss/_mixins.scss`](#scssglobalsscss_mixinsscss)                 | Removed, import mixins directly from appropriate file                     |
| [`scss/globals/scss/_motion.scss`](#scssglobalsscss_motionscss)                 | Moved to `scss/_motion.scss`                                              |
| [`scss/globals/scss/_spacing.scss`](#scssglobalsscss_spacingscss)               | Moved to `scss/_spacing.scss`                                             |
| [`scss/globals/scss/_theme-tokens.scss`](#scssglobalsscss_theme-tokensscss)     | Moved to `scss/_themes.scss`                                              |
| [`scss/globals/scss/_theme.scss`](#scssglobalsscss_themescss)                   | Moved to `scss/_theme.scss`                                               |
| [`scss/globals/scss/_typography.scss`](#scssglobalsscss_typographyscss)         | Moved to `scss/_type.scss`                                                |
| [`scss/globals/scss/_vars.scss`](#scssglobalsscss_varsscss)                     | Removed, import variables directly from appropriate file                  |
| `scss/globals/scss/vendor/*`                                                    | These files are now re-exported from the top-level `scss` folder          |

#### scss/globals/scss/styles.scss

| v10                                                          | v11                      |
| :----------------------------------------------------------- | :----------------------- |
| `@import 'carbon-components/scss/globals/scss/styles.scss';` | `@use '@carbon/styles';` |
| (alias)                                                      | `@use '@carbon/react';`  |

The `styles.scss` entry point was provided as a way to bring in all of the
styles for the Carbon Design System. In v11, this is available through
`@carbon/styles/index.scss` which can be directly imported with `@use` by
writing out:

```scss
@use '@carbon/styles';
```

If you are overriding different settings of the project, like `$prefix`, you
will need to pass those into the `with` block in the import:

```scss
@use '@carbon/styles' with (
  $prefix: 'cds'
);
```

While the preference is to import files using `@use`, you may also use `@import`
to bring in styles.

For a full overview of changes to how you configure Carbon, check our
[configuration](#configuration) section below.

#### scss/globals/scss/\_colors.scss

| v10                                                     | v11                                  |
| :------------------------------------------------------ | :----------------------------------- |
| `@import 'carbon-components/scss/globals/scss/colors';` | `@use '@carbon/styles/scss/colors';` |
|                                                         | `@use '@carbon/react/scss/colors';`  |

The `scss/globals/scss/_colors.scss` entry point provided a re-export of the
`@carbon/colors` package. This entry point now lives at `scss/_colors.scss` in
`@carbon/styles` and can be included by writing:

```scss
@use '@carbon/styles/scss/colors';

.example {
  color: colors.$blue-50;
}
```

The following is a list of API changes in v11 for `@carbon/colors` that are
present in `@carbon/styles/scss/colors`:

| v10                     | v11                            |
| :---------------------- | :----------------------------- |
| `$ibm-*` variables      | Removed                        |
| `$carbon-*` variables   | Removed                        |
| `$ibm-color-map`        | Removed                        |
| `$carbon--colors`       | Removed, replaced by `$colors` |
| `@mixin ibm--colors`    | Removed                        |
| `@mixin carbon--colors` | Removed                        |

#### scss/globals/scss/\_css--font-face.scss

In v11, we support a broad range of font families from IBM Plex through the
`@ibm/plex` package. By default, these font families are loaded through the
`@ibm/plex` package and require a bundler that supports loading in font files in
this way.

You can still configure Carbon to pull in these fonts through a CDN with the
`$use-akamai-cdn` flag available in `scss/_config.scss`.

IBM Plex Sans, IBM Plex Mono, and IBM Plex Serif are all loaded in automatically
with light, normal, and medium font weights. You can configure the `scss/fonts`
import to include additional font families and font weights.

For more information, check out the
[documentation](../../packages/styles/scss/fonts/README.md).

#### scss/globals/scss/\_css--helpers.scss

The `scss/globals/scss/_css--helpers` entry point provides class-based helpers
when the `$css--helpers` flag is set to true, specifically:

- `bx--assistive-text` and `bx--visually-hidden`
- `bx--body`

In v11, the assistive text and visually hidden classes are now available under:
`scss/utilities/_visually-hidden`.

The `bx--body` class has been removed.

#### scss/globals/scss/\_css--reset.scss

| v10                                                         | v11                                 |
| :---------------------------------------------------------- | :---------------------------------- |
| `@import 'carbon-components/scss/globals/scss/css--reset';` | `@use '@carbon/styles/scss/reset';` |
|                                                             | `@use '@carbon/react/scss/reset';`  |

The `scss/globals/scss/css--reset` entry point is used for including a CSS reset
in a project using Carbon. It is configurable using the `$css--reset` global
flag.

In v11, this entry point is now available at `scss/reset` and is still
configurable with the `$css--reset` configuration option. By default,
`$css--reset` is set to `true`.

#### scss/globals/scss/\_helper-classes.scss

The `scss/globals/scss/_helper-classes.scss` entry point was used to emit CSS
classes for text truncation, specifically:

- `bx--text-truncate--end`
- `bx--text-truncate--front`

These classes are now available under `scss/utilities/text-truncate`.

#### scss/globals/scss/\_helper-mixins.scss

The `scss/globals/scss/_helper-mixins.scss` entry point exported a number of
helper mixins that could be used when building components. In v11, these helpers
have been moved to utilities located under `scss/utilities/`. Below is a table
that details to which files a particular helper has been moved.

| v10                         | v11                                       |
| :-------------------------- | :---------------------------------------- |
| `@mixin text-overflow`      | `scss/utilities/_text-overflow.scss`      |
| `@mixin placeholder-colors` | `scss/utilities/_placeholder-colors.scss` |
| `@mixin box-shadow`         | `scss/utilities/_box-shadow.scss`         |
| `@mixin focus-outline`      | `scss/utilities/_focus-outline.scss`      |
| `@mixin rotate`             | `scss/utilities/_rotate.scss`             |
| `@mixin hidden`             | `scss/utilities/_visually-hidden.scss`    |
| `@mixin button-reset`       | `scss/utilities/_button-reset.scss`       |
| `@mixin skeleton`           | `scss/utilities/_skeleton.scss`           |
| `@keyframes skeleton`       | `scss/utilities/_keyframes.scss`          |
| `@mixin high-contrast-mode` | `scss/utilities/_high-contrast-mode.scss` |

#### scss/globals/scss/\_layout.scss

This entry point has been split into two files. For anything related to spacing
or layout, you can use the `scss/spacing` entry point directly. For anything
related to z-index you can use `scss/utilities/z-index` directly.

#### scss/globals/scss/\_mixins.scss

The `scss/globals/scss/_mixins.scss` entry point re-exported mixins from the
following files:

- `scss/globals/scss/helper-mixins`
- `scss/components/button/mixins`;
- `scss/components/loading/mixins`;
- `scss/components/notification/mixins`;
- `scss/components/tag/mixins`;
- `scss/components/structured-list/mixins`;

In v11, this entry point has been removed. If you are using a mixin from this
entry point, find the appropriate mixin from the migration guidance for one of
the files above.

#### scss/globals/scss/\_motion.scss

| v10                                                     | v11                                  |
| :------------------------------------------------------ | :----------------------------------- |
| `@import 'carbon-components/scss/globals/scss/motion';` | `@use '@carbon/styles/scss/motion';` |
|                                                         | `@use '@carbon/react/scss/motion';`  |

The `scss/globals/scss/_motion.scss` entry point re-exported exports from the
`@carbon/motion` package along with providing a number of helpers and variables
for duration and easing curves.

| v10                        | v11                                |
| :------------------------- | :--------------------------------- |
| `$carbon--ease-in`         | Renamed to `$ease-in`              |
| `$carbon--ease-out`        | Renamed to `$ease-out`             |
| `$carbon--standard-easing` | Renamed to `$standard-easing`      |
| `$transition--base`        | Renamed to `$transition-base`      |
| `$transition--expansion`   | Renamed to `$transition-expansion` |
| `$duration--fast-01`       | `$duration-fast-01`                |
| `$duration--fast-02`       | `$duration-fast-02`                |
| `$duration--moderate-01`   | `$duration-moderate-01`            |
| `$duration--moderate-02`   | `$duration-moderate-01`            |
| `$duration--slow-01`       | `$duration-slow-01`                |
| `$duration--slow-02`       | `$duration-slow-02`                |
| `@function motion`         | No changes                         |
| `@mixin motion`            | No changes                         |

For a full overview of what is available in this entry point, check out the
[API documentation](../../packages/motion/docs/sass.md#api) for the
`@carbon/motion` package.

#### `scss/globals/scss/_spacing.scss`

| v10                                                      | v11                                   |
| :------------------------------------------------------- | :------------------------------------ |
| `@import 'carbon-components/scss/globals/scss/spacing';` | `@use '@carbon/styles/scss/spacing';` |

The `scss/globals/scss/_spacing.scss` entry point provided a number of variables
for spacing and include re-exports from the `@carbon/layout` package for
`mini-unit` support as well as the spacing scale.

In v11, this entry point has been moved to `scss/_spacing.scss` and a number of
exports have been changed.

| v10                            | v11                                  |
| :----------------------------- | :----------------------------------- |
| `$spacing-01`                  | No changes                           |
| `$spacing-02`                  | No changes                           |
| `$spacing-03`                  | No changes                           |
| `$spacing-04`                  | No changes                           |
| `$spacing-05`                  | No changes                           |
| `$spacing-06`                  | No changes                           |
| `$spacing-07`                  | No changes                           |
| `$spacing-08`                  | No changes                           |
| `$spacing-09`                  | No changes                           |
| `$spacing-10`                  | No changes                           |
| `$spacing-11`                  | No changes                           |
| `$spacing-12`                  | No changes                           |
| `$spacing-13`                  | No changes                           |
| `$carbon--spacing`             | Renamed to `$spacing`                |
| `$carbon--spacing-01`          | Removed, replaced with `$spacing-01` |
| `$carbon--spacing-02`          | Removed, replaced with `$spacing-02` |
| `$carbon--spacing-03`          | Removed, replaced with `$spacing-03` |
| `$carbon--spacing-04`          | Removed, replaced with `$spacing-04` |
| `$carbon--spacing-05`          | Removed, replaced with `$spacing-05` |
| `$carbon--spacing-06`          | Removed, replaced with `$spacing-06` |
| `$carbon--spacing-07`          | Removed, replaced with `$spacing-07` |
| `$carbon--spacing-08`          | Removed, replaced with `$spacing-08` |
| `$carbon--spacing-09`          | Removed, replaced with `$spacing-09` |
| `$carbon--spacing-10`          | Removed, replaced with `$spacing-10` |
| `$carbon--spacing-11`          | Removed, replaced with `$spacing-11` |
| `$carbon--spacing-12`          | Removed, replaced with `$spacing-12` |
| `$carbon--spacing-13`          | Removed, replaced with `$spacing-13` |
| `$spacing-baseline`            | Removed                              |
| `$spacing-4xs`                 | Removed                              |
| `$spacing-3xs`                 | Removed                              |
| `$spacing-2xs`                 | Removed                              |
| `$spacing-xs`                  | Removed                              |
| `$spacing-sm`                  | Removed                              |
| `$spacing-md`                  | Removed                              |
| `$spacing-lg`                  | Removed                              |
| `$spacing-xl`                  | Removed                              |
| `$spacing-2xl`                 | Removed                              |
| `$spacing-3xl`                 | Removed                              |
| `$carbon--layout-01`           | Removed, replaced by `$spacing-05`   |
| `$carbon--layout-02`           | Removed, replaced by `$spacing-06`   |
| `$carbon--layout-03`           | Removed, replaced by `$spacing-07`   |
| `$carbon--layout-04`           | Removed, replaced by `$spacing-09`   |
| `$carbon--layout-05`           | Removed, replaced by `$spacing-10`   |
| `$carbon--layout-06`           | Removed, replaced by `$spacing-12`   |
| `$carbon--layout-07`           | Removed, replaced by `$spacing-13`   |
| `$layout-01`                   | Removed, replaced by `$spacing-05`   |
| `$layout-02`                   | Removed, replaced by `$spacing-06`   |
| `$layout-03`                   | Removed, replaced by `$spacing-07`   |
| `$layout-04`                   | Removed, replaced by `$spacing-09`   |
| `$layout-05`                   | Removed, replaced by `$spacing-10`   |
| `$layout-06`                   | Removed, replaced by `$spacing-12`   |
| `$layout-07`                   | Removed, replaced by `$spacing-13`   |
| `$layout-2xs`                  | Removed                              |
| `$layout-xs`                   | Removed                              |
| `$layout-sm`                   | Removed                              |
| `$layout-md`                   | Removed                              |
| `$layout-lg`                   | Removed                              |
| `$layout-xl`                   | Removed                              |
| `$layout-2xl`                  | Removed                              |
| `$carbon--layout`              | Removed                              |
| `$carbon--mini-unit-size`      | Removed                              |
| `@function carbon--mini-units` | Removed                              |

For a full overview of what is available in this entry point, check out the
[API documentation](../../packages/layout/docs/sass.md#api) for the
`@carbon/layout` package.

#### scss/globals/scss/\_theme-tokens.scss

The `scss/globals/scss/_theme-tokens.scss` entry point provides several
component tokens along with re-exports from `@carbon/themes` package.

| v10                                      | v11                                           |
| :--------------------------------------- | :-------------------------------------------- |
| Design tokens                            | Available in `scss/_theme.scss`               |
| `$focus`                                 | Available directly in the theme               |
| `$inverse-focus-ui`                      | Available directly in the theme               |
| `$accordion-flex-direction`              | Moved to `scss/components/accordion`          |
| `$accordion-justify-content`             | Moved to `scss/components/accordion`          |
| `$accordion-arrow-margin`                | Moved to `scss/components/accordion`          |
| `$accordion-title-margin`                | Moved to `scss/components/accordion`          |
| `$accordion-content-padding`             | Moved to `scss/components/accordion`          |
| `$button-font-weight`                    | Moved to `scss/components/button`             |
| `$button-font-size`                      | Moved to `scss/components/button`             |
| `$button-border-radius`                  | Moved to `scss/components/button`             |
| `$button-height`                         | Moved to `scss/components/button`             |
| `$button-padding`                        | Moved to `scss/components/button`             |
| `$button-padding-field`                  | Moved to `scss/components/button`             |
| `$button-padding-sm`                     | Moved to `scss/components/button`             |
| `$button-padding-lg`                     | Moved to `scss/components/button`             |
| `$button-padding-ghost`                  | Moved to `scss/components/button`             |
| `$button-padding-ghost-field`            | Moved to `scss/components/button`             |
| `$button-padding-ghost-sm`               | Moved to `scss/components/button`             |
| `$button-border-width`                   | Moved to `scss/components/button`             |
| `$button-outline-width`                  | Moved to `scss/components/button`             |
| `$button-outline-offset`                 | Moved to `scss/components/button`             |
| `$button-outline`                        | Moved to `scss/components/button`             |
| `$copy-active`                           | Moved to `scss/components/code-snippet`       |
| `$copy-btn-feedback`                     | Moved to `scss/components/code-snippet`       |
| `$checkbox-border-width`                 | Moved to `scss/components/checkbox`           |
| `$content-switcher-border-radius`        | Moved to `scss/components/content-switcher`   |
| `$content-switcher-option-border`        | Moved to `scss/components/content-switcher`   |
| `$content-switcher-divider`              | Moved to `scss/components/content-switcher`   |
| `$data-table-heading-transform`          | Moved to `scss/components/data-table`         |
| `$data-table-heading-border-bottom`      | Moved to `scss/components/data-table`         |
| `$data-table-row-height`                 | Moved to `scss/components/data-table`         |
| `$data-table-zebra-color`                | Moved to `scss/components/data-table`         |
| `$data-table-column-hover`               | Moved to `scss/components/data-table`         |
| `$date-picker-in-range-background-color` | Moved to `scss/components/data-table`         |
| `$input-border`                          | Removed                                       |
| `$input-label-weight`                    | Moved to `scss/components/form`               |
| `$link-visited`                          | Moved to `scss/components/link`               |
| `$link-inverse-color`                    | Moved to `scss/components/link`               |
| `$modal-border-top`                      | Moved to `scss/components/modal`              |
| `$modal-footer-background-color`         | Moved to `scss/components/modal`              |
| `$notification-info-background-color`    | Moved to `scss/components/notification`       |
| `$notification-error-background-color`   | Moved to `scss/components/notification`       |
| `$notification-warning-background-color` | Moved to `scss/components/notification`       |
| `$notification-success-background-color` | Moved to `scss/components/notification`       |
| `$progress-indicator-bar-width`          | Moved to `scss/components/progress-indicator` |
| `$progress-indicator-stroke-width`       | Moved to `scss/components/progress-indicator` |
| `$progress-indicator-line-offset`        | Moved to `scss/components/progress-indicator` |
| `$snippet-background-color`              | Moved to `scss/components/code-snippet`       |
| `$snippet-border-color`                  | Moved to `scss/components/code-snippet`       |
| `$radio-border-width`                    | Moved to `scss/components/radio-button`       |
| `$structured-list-padding`               | Moved to `scss/components/structured-list`    |
| `$structured-list-text-transform`        | Moved to `scss/components/structured-list`    |
| `$tab-underline-color`                   | Moved to `scss/components/tabs`               |
| `$tab-underline-color-hover`             | Moved to `scss/components/tabs`               |
| `$tab-text-disabled`                     | Moved to `scss/components/tabs`               |
| `$tab-underline-disabled`                | Moved to `scss/components/tabs`               |
| `$tooltip-background-color`              | Moved to `scss/components/tooltip`            |
| `$skeleton`                              | Removed, available as a token in the theme    |

#### scss/globals/scss/\_theme.scss

| v10                                                    | v11                                 |
| :----------------------------------------------------- | :---------------------------------- |
| `@import 'carbon-components/scss/globals/scss/theme';` | `@use '@carbon/styles/scss/theme';` |
|                                                        | `@use '@carbon/react/scss/theme';`  |

The `scss/globals/scss/_theme.scss` entry point re-exported tokens from the
`_theme-tokens.scss` entry point. In v11, you can import this file directly and
reference the current theme, tokens defined in the theme, as well as dynamically
retrieve the current value of a token.

```scss
@use '@carbon/styles/scss/theme';

.example {
  background: theme.$background;
  color: theme.$text-primary;
}
```

For a full overview of what is available in this entry point, check out our
[API documentation](../../packages/styles/docs/sass.md#theme).

#### scss/globals/scss/\_typography.scss

| v10                                                         | v11                                |
| :---------------------------------------------------------- | :--------------------------------- |
| `@import 'carbon-components/scss/globals/scss/typography';` | `@use '@carbon/styles/scss/type';` |
|                                                             | `@use '@carbon/react/scss/type';`  |

The `scss/globals/scss/_typography.scss` entry point provides access to a number
of variables and helpers for working with dimensions. It also re-exports several
exports from `@carbon/type`.

In v11, this entry point has been moved to `scss/_type.scss` and several of its
exports have changed or removed.

| v10                             | v11                                     |
| :------------------------------ | :-------------------------------------- |
| `$base-font-size`               | Moved to `scss/utilities/_convert.scss` |
| `@function rem`                 | Moved to `scss/utilities/_convert.scss` |
| `@function em`                  | Moved to `scss/utilities/_convert.scss` |
| `$carbon--font-families`        | Renamed to `$font-families`             |
| `@function carbon--font-family` | Renamed to `@function font-family`      |
| `@mixin carbon--font-family`    | Renamed to `@mixin font-family`         |
| `$carbon--font-weights`         | Renamed to `$font-weights`              |
| `@function carbon--font-weight` | Renamed to `@function font-weight`      |
| `@mixin carbon--font-weight`    | Renamed to `@mixin font-weight`         |

For a full overview of what is available in this entry point, check out the
[API documentation](../../packages/type/docs/sass.md#api) for `@carbon/type`.

#### scss/globals/scss/\_vars.scss

The `scss/globals/scss/_vars.scss` entry point was used to access most of the
public variables from the Carbon Design System. It also specified the `$prefix`
used for CSS.examples in the codebase.

In v11, this file has been removed. To get access to variables that you
previously were using `_vars.scss` for, you will need to find the correct direct
import. For changing the `$prefix` used in the project, you can configure this
through the `scss/_config.scss` entry point.

For more information about configuring the project, check out the
[configuration](#configuration) section below.

#### scss/globals/grid/\_grid.scss

| v10                                                   | v11                                |
| :---------------------------------------------------- | :--------------------------------- |
| `@import 'carbon-components/scss/globals/grid/grid';` | `@use '@carbon/styles/scss/grid';` |
|                                                       | `@use '@carbon/react/scss/grid';`  |

The `scss/globals/grid/_grid.scss` entry point provides access to the flexbox
based grid from the `@carbon/grid` package.

In v11, this entry point has been moved to `scss/_grid.scss` and continues to
re-export from the `@carbon/grid` package. In addition, the default grid has
been changed from the 12 column variant to the 16 column grid.

_Note: if you're using `$feature-flags` to set `grid-columns-16` you can remove
this flag in v11_

Finally, our default grid implementation no longer uses flexbox. Instead, it
uses CSS Grid. If you have existing layouts built using the flexbox grid, you
can bring in these styles through the `scss/grid/flexbox` entry point or via the
`$use-flexbox-grid` config variable.

### scss/components

The components located under `scss/components` are available under
`scss/components/<component>/_<component>.scss`. For example, to import an
accordion:

```scss
@import 'carbon-components/scss/components/accordion/accordion';
```

In v11, these files now live at `scss/components/<component>/_index.scss` and
can be shortened to `scss/components/<component>` since Dart Sass resolves
`_index.scss` files automatically. for example:

```scss
// For styles
@use '@carbon/styles/scss/components/accordion';

// For React
@use '@carbon/react/scss/components/accordion';
```

#### scss/components/data-table_data-table.scss

DataTable styles are no longer all bundled into one stylesheet. To include
styles for DataTable actions, expand, skeleton, and sort you'll need to `@use`
each module as needed.

| v10                                                                  | v11                                                            |
| :------------------------------------------------------------------- | :------------------------------------------------------------- |
| `@import 'carbon-components/scss/components/data-table/data-table';` | `@use '@carbon/styles/scss/components/data-table';`            |
|                                                                      | `@use '@carbon/styles/scss/components/data-table/action';`     |
|                                                                      | `@use '@carbon/styles/scss/components/data-table/expandable';` |
|                                                                      | `@use '@carbon/styles/scss/components/data-table/skeleton';`   |
|                                                                      | `@use '@carbon/styles/scss/components/data-table/sort';`       |

#### Component tokens

In some situations, you may want to use or change the tokens for a specific
component. To do so you will need to configure the module and provide the tokens
you would like to see changed. For full details, see
[the sass documentation for `@carbon/styles`](../../packages/styles/docs/sass.md#components).

### Configuration

In v10, you could configure various aspects of Carbon using global flags that
were set before including Carbon. For example, you could change the prefix used
or disable the CSS reset that the project used by doing the following:

```scss
$prefix: 'cds';
$css--reset: false;

@import 'path/to/carbon';
```

Similarly, you could enable or disable `$feature-flags` for the project with a
similar approach.

This approach no longer works with the project's switch to Sass Modules.
Instead, you will need to configure Carbon through the `scss/_config.scss` entry
point using `with`. This file is re-exported in various entry points, so you can
configure Carbon on the main entry point:

```scss
@use '@carbon/styles' with (
  $prefix: 'cds'
);
```

Or you can configure the `scss/_config.scss` directly:

```scss
@use '@carbon/styles/scss/config' with (
  $prefix: 'cds'
);
```

_Note: Sass modules can only ever be configured once. Bringing in this module
and configuring it should be one of the first things you do in your project._

The following is a table of configuration options and their status in v11. Ones
that are available you can configure through the `scss/_config.scss` entry
point, ones that are removed are no longer available.

| v10               | v11                           |
| :---------------- | :---------------------------- |
| `$css--helpers`   | Removed                       |
| `$css--body`      | Removed                       |
| `$css--use-layer` | Removed                       |
| `$css--reset`     | No changes                    |
| `$prefix`         | No changes                    |
| `$feature-flags`  | Moved to `scss/feature-flags` |

### Internal

The following files are considered internal files and have been omitted from
this migration document. If you are currently using these files, please reach
out for support on
[GitHub Discussions](https://github.com/carbon-design-system/carbon/discussions/categories/help)
and we can help you migrate from the following list of files:

- `scss/globals/scss/_functions.scss`
- `scss/globals/scss/_feature-flags.scss`
- `scss/globals/scss/_deprecate.scss`
- `scss/globals/scss/_keyframes.scss`
- `scss/globals/scss/_tooltip.scss`
- `scss/globals/scss/vendor/*`

## carbon-components-react

The `carbon-components-react` package has been replaced by the `@carbon/react`
package in v11. `carbon-components-react` reached it's end of support on
September 30, 2024. This package will no longer receive updates.

In addition, v11 contains updates to React components in the package. These
updates include:

- Changing components from class components to functional components
- Creating consistent prop names and types across components
- Updates to make components more accessible

Some of these updates are covered by an automated codemod. View full
instructions in [`@carbon/upgrade`](../../packages/upgrade/README.md).

#### Rewrite imports from `carbon-components-react` to `@carbon/react`.

```bash
npx @carbon/upgrade migrate update-carbon-components-react-import-to-scoped --write
```

#### Automates size prop changes.

```bash
npx @carbon/upgrade migrate small-to-size-props --write
npx @carbon/upgrade migrate size-prop-updates --write
```

For a full overview of changes to components, checkout our components section
below.

| Component                  | Changes                                                                                                                                                  |
| :------------------------- | :------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `Accordion`                | The `size` prop has been updated and no longer includes `xl`                                                                                             |
| `AccordionItem`            | View changes [here](#accordionitem)                                                                                                                      |
| `AccordionSkeleton`        | The deprecated prop `uid` is no longer needed and has been removed                                                                                       |
| `ActionableNotification`   | View changes [here](#notifications)                                                                                                                      |
| `Button`                   | View changes [here](#button)                                                                                                                             |
| `ButtonSkeleton`           | View changes [here](#buttonskeleton)                                                                                                                     |
| `Checkbox`                 | View changes [here](#checkbox)                                                                                                                           |
| `ClickableTile`            | View changes [here](#clickabletile)                                                                                                                      |
| `Column`                   | View changes [here](#grid)                                                                                                                               |
| `ComboBox`                 | The `className` prop is now applied to the outermost element of `ComboBox`                                                                               |
| `ComposedModal`            | Updated from a class to functional component                                                                                                             |
| `ContentSwitcher`          | Updated from a class to functional component                                                                                                             |
| `ControlledPasswordInput`  | The `size` prop has been updated to match `PasswordInput`                                                                                                |
| `DatePicker`               | View changes [here](#datepicker)                                                                                                                         |
| `DatePickerInput`          | View changes [here](#datepickerinput)                                                                                                                    |
| `Dropdown`                 | View changes [here](#dropdown)                                                                                                                           |
| `DropdownSkeleton`         | The deprecated prop `inline` has been removed                                                                                                            |
| `ExpandableTile`           | View changes [here](#expandabletile)                                                                                                                     |
| `FileUploader`             | View changes [here](#fileuploader)                                                                                                                       |
| `FileUploaderButton`       | View changes [here](#fileuploaderbutton)                                                                                                                 |
| `FileUploaderItem`         | The size prop has been updated to: `PropTypes.oneOf(['sm', 'md', 'lg'])`. Previous values such as `default`, `field`, or `small` are no longer supported |
| `FilterableMultiSelect`    | View changes [here](#filterablemultiselect)                                                                                                              |
| `FluidForm`                | Vertical margin for form items and fieldsets is no longer included by default, use `<Stack>` for vertical spacing                                        |
| `Form`                     | Vertical margin for form items and fieldsets is no longer included by default, use `<Stack>` for vertical spacing                                        |
| `FormGroup`                | View changes [here](#formgroup)                                                                                                                          |
| `FormLabel`                | The FormLabel component no longer applies margin                                                                                                         |
| `Grid`                     | View changes [here](#grid)                                                                                                                               |
| `HeaderMenu`               | Updated from a class to functional component                                                                                                             |
| `HeaderNavigation`         | Updated from a class to functional component                                                                                                             |
| `Icon`                     | Removed                                                                                                                                                  |
| `InlineLoading`            | The deprecated success prop has been deprecated. Please use status="finished" instead                                                                    |
| `InlineNotification`       | View changes [here](#notifications)                                                                                                                      |
| `Modal`                    | View changes [here](#modal)                                                                                                                              |
| `ModalFooter`              | Updated from a class to functional component                                                                                                             |
| `ModalHeader`              | Updated from a class to functional component                                                                                                             |
| `ModalWrapper`             | Removed                                                                                                                                                  |
| `MultiSelect`              | The `className` prop is now applied to the outermost element of `MultiSelect`                                                                            |
| `NotificationActionButton` | View changes [here](#notifications)                                                                                                                      |
| `NotificationButton`       | View changes [here](#notifications)                                                                                                                      |
| `NotificationTextDetails`  | View changes [here](#notifications)                                                                                                                      |
| `NumberInput`              | View changes [here](#numberinput)                                                                                                                        |
| `OverflowMenu`             | View changes [here](#overflowmenu)                                                                                                                       |
| `OverflowMenuItem`         | View changes [here](#overflowmenuitem)                                                                                                                   |
| `Pagination`               | Updated from a class to functional component                                                                                                             |
| `PasswordInput`            | The `size` prop has been updated to: `PropTypes.oneOf(['sm', 'md', 'lg'])`                                                                               |
| `ProgressIndicator`        | Updated from a class to functional component                                                                                                             |
| `RadioButton`              | Updated from a class to functional component                                                                                                             |
| `RadioButtonGroup`         | View changes [here](#radiobuttongroup)                                                                                                                   |
| `RadioTile`                | View changes [here](#radiotile)                                                                                                                          |
| `Row`                      | View changes [here](#grid)                                                                                                                               |
| `Search`                   | View changes [here](#search)                                                                                                                             |
| `SearchFilterButton`       | Removed                                                                                                                                                  |
| `SearchLayoutButton`       | Removed                                                                                                                                                  |
| `Select`                   | View changes [here](#select)                                                                                                                             |
| `SelectableTile`           | View changes [here](#selectabletile)                                                                                                                     |
| `SideNavMenu`              | Updated from a class to functional component                                                                                                             |
| `Slider`                   | View changes [here](#slider)                                                                                                                             |
| `StructuredListBody`       | Vertical margin for form items and fieldsets is no longer included by default, use `<Stack>` for vertical spacing                                        |
| `StructuredListInput`      | View changes [here](#structuredlistinput)                                                                                                                |
| `StructuredListRow`        | The `label` prop is no longer needed and has been deprecated                                                                                             |
| `StructuredListWrapper`    | The deprecated prop `border` has been removed                                                                                                            |
| `Table`                    | View changes [here](#table)                                                                                                                              |
| `TableToolbar`             | The `size` prop has been updated to: `PropTypes.oneOf(['sm', 'lg'])`. Previous values such as `small` or `normal` are no longer supported                |
| `TableToolbarSearch`       | View changes [here](#tabletoolbarsearch)                                                                                                                 |
| `Tabs`                     | View changes [here](#tabs)                                                                                                                               |
| `Tab`                      | View changes [here](#tabs)                                                                                                                               |
| `TabContent`               | View changes [here](#tabs)                                                                                                                               |
| `TabsSkeleton`             | View changes [here](#tabs)                                                                                                                               |
| `TextArea`                 | The `className` prop is now applied to the outermost element of `TextArea`                                                                               |
| `TextInput`                | View changes [here](#textinput)                                                                                                                          |
| `Tile`                     | View changes [here](#tile)                                                                                                                               |
| `TileAboveTheFoldContent`  | Updated from a class to functional component                                                                                                             |
| `TileBelowTheFoldContent`  | Updated from a class to functional component                                                                                                             |
| `TileGroup`                | Updated from a class to functional component                                                                                                             |
| `TimePicker`               | View changes [here](#timepicker)                                                                                                                         |
| `TimePickerSelect`         | View changes [here](#timepickerselect)                                                                                                                   |
| `ToastNotification`        | View changes [here](#notifications)                                                                                                                      |
| `Toggle`                   | View changes [here](#toggle)                                                                                                                             |
| `ToggleSkeleton`           | Removed                                                                                                                                                  |
| `ToggleSmall`              | This component has been removed. Please use `<Toggle size="sm">` instead                                                                                 |
| `ToggleSmallSkeleton`      | Removed                                                                                                                                                  |
| `Toolbar`                  | Removed                                                                                                                                                  |
| `ToolbarDivider`           | Removed                                                                                                                                                  |
| `ToolbarItem`              | Removed                                                                                                                                                  |
| `ToolbarOption`            | Removed                                                                                                                                                  |
| `ToolbarSearch`            | Removed                                                                                                                                                  |
| `ToolbarTitle`             | Removed                                                                                                                                                  |
| `Tooltip`                  | View changes [here](#tooltips)                                                                                                                           |
| `TooltipDefinition`        | View changes [here](#tooltips)                                                                                                                           |
| `TooltipIcon`              | View changes [here](#tooltips)                                                                                                                           |

### AccordionItem

- The deprecated prop `renderExpando` has been removed, use `renderToggle`
  instead
- The deprecated prop `iconDescription` is no longer needed and has been removed

### Button

- The deprecated prop `small` has been removed. Please use `size="sm"` instead
- The `size` prop has been updated to:
  `PropTypes.oneOf(['sm', 'md', 'lg', 'xl', '2xl'])`. Previous size values like
  `default`, `field`, or `small` are no longer supported.

### ButtonSkeleton

- The `size` prop has been updated to:
  `PropTypes.oneOf(['sm', 'md', 'lg', 'xl', '2xl'])`. Previous size values like
  `default`, `field`, or `small` are no longer supported.

### Checkbox

- The deprecated prop `wrapperClassName` has been removed. Use `className`
  instead.
- The `onChange` prop signature has been updated. Previously, this prop would be
  a function of type: `(boolean, string, Event) => void`. It has now been
  updated to pass the `onChange` event as the first argument and the second
  argument is the state.

```diff
<Checkbox
-  onChange={(checked, id, event) => {
-    //
-  }}
+  onChange={(event, { checked, id }) => {
+    //
+  }}
/>
```

### DatePicker

- This component has been updated from a class component to a functional
  component
- The `className` prop is now applied to the outermost element of `DatePicker`

### DatePickerInput

- This component has been updated from a class component to a functional
  component
- The deprecated prop `iconDescription` has been removed
- The deprecated prop `openCalendar` has been removed

### Dropdown

- The `className` prop is now applied to the outermost element of `Dropdown`
- The deprecated prop `inline` has been removed. Please use `type="inline"`
  instead

### FileUploader

- This component has been updated from a class component to a functional
  component
- The `iconDescription` prop is now required to label the icon

### FileUploaderButton

- Vertical margin is no longer included by default, use `<Stack>` for vertical
  spacing
- The `size` prop has been updated to: `PropTypes.oneOf(['sm', 'md', 'lg'])`.
  Previous values such as `default`, `field`, or `small` are no longer supported

### FilterableMultiSelect

- This component has been updated from a class component to a functional
  component
- The `className` prop is now applied to the outermost element of
  `FilterableMultiSelect`

### FormGroup

- The `className` prop is now applied to the outermost element of `FormGroup`
- The deprecated prop `hasMargin` has been removed. Margin for vertical spacing
  is no longer included, use `<Stack>` for vertical spacing.

### Grid

The `Grid` component has been updated to use our new CSS Grid classes under the
hood. However, if you're using the `Grid` component in v10 you can continue
using our flexbox-based grid with the `FlexGrid` component. Similarly, `Row` and
`Column` will continue to work with `FlexGrid`.

With the change to CSS Grid, you now will only need two components to build
layouts: `Grid` and `Column`. The `Row` component is no longer needed.

**New**

- Subgrid is officially supported when using CSS Grid

**Changed**

- The `Grid` component now uses CSS Grid under the hood. If you would like to
  keep using the flexbox-based grid, use `FlexGrid` instead.

### FlexGrid

The `FlexGrid` component has the same API as the `Grid` component in v10. You
can build layouts using `FlexGrid`, `Row`, and `Column`. You can also keep
existing layouts that you've already built using this component.

### Row

This component has not changed between v10 and v11. However, it is no longer
needed when building layouts with `Grid`. Instead, you can use `Grid` and
`Column` directly.

### Column

The `Column` component has specific additions to work with CSS Grid. It
maintains backward compatibility with v10. The biggest change between v10 and
v11 is that `Columns` no longer will auto-span. Instead, each `Column` will span
1 column in the grid unless otherwise specified.

There are also changes to how `offset` works in v11. While you can continue to
use `offset` in each breakpoint prop, you can now use `start` and `end`, as
well. These correspond to `grid-column-start` and `grid-column-end`,
respectively.

View the docs for the [`Column` component](#todo) to learn more.

### Modal

- This component has been updated from a class component to a functional
  component
- The deprecated prop `focusTrap` has been removed, this is now enabled by
  default
- The deprecated prop `hasForm` has been removed, this is now enabled by default
- The deprecated prop `iconDescription` is no longer needed and has been removed

### Notifications

The notification components have been updated to be more accessible out of the
box. `ToastNotification` and `InlineNotification` now have `role="status"` by
default with additional `role` options of `log` and `alert`. These components do
not receive focus and should be used for information-only use cases. These
components no longer accept actions or interactive children.

For notifications requiring an action, a new `ActionableNotifiation` component
is available. It has a `role="alertdialog"` and recieves focus by default.
Automatic placement of focus can be turned off via the new `hasFocus` prop.

All notifications have a new optional `closeOnEscape` prop, which enables
notifications to close by pressing the `escape` key. For more details, see the
[notification components accessibility page](https://v11.carbondesignsystem.com/components/notification/accessibility).

Vertical margin is no longer included by default, use `<Stack>` for vertical
spacing.

`ToastNotification` updates:

- `children` can no longer contain interactive elements. A `ToastNotification`
  containing an action or interactive children should be replaced with
  `ActionableNotification`.
- The `notificationType` prop is no longer needed and can be removed.
- The default `role` is now `status`. `log` and `alert` can also be used.
- The `closeOnEscape` prop toggles the closing of notifications via the `escape`
  key.

`InlineNotification` updates:

- The `actions` prop has been removed. An `InlineNotification` containing an
  action or interactive children should be replaced with
  `ActionableNotification` configured with the `inline` prop.
- `children` can no longer contain interactive elements.
- The `notificationType` prop is no longer needed and can be removed.
- The default `role` is now `status`. `log` and `alert` can also be used.
- The `closeOnEscape` prop toggles the closing of notifications via the `escape`
  key.

`ActionableNotification` config options:

- The `inline` prop enables a styling variation resulting in a similar visual
  design to `InlineNotification`.
- The `actionButtonLabel` prop configures the action button text.
- The `hasFocus` prop toggles the automatic placement of focus.
- The `closeOnEscape` prop toggles the closing of notifications via the `escape`
  key.

### NumberInput

- The deprecated prop `isMobile` is no longer needed and has been removed
- The `className` prop is now applied to the outermost element of `NumberInput`
- `imaginaryTarget` is no longer available on the `onChange` event
  - The signature for `onChange` is `onChange(event, {value, direction})`
  - To fully control a NumberInput, use `value` to track internal state updates

### OverflowMenu

- This component has been updated from a class component to a functional
  component
- The prop `light` has been deprecated, use the `Layer` component instead

### OverflowMenuItem

- This component has been updated from a class component to a functional
  component
- The deprecated prop `primaryFocus` is no longer needed and has been removed.
  Prefer `selectorPrimaryFocus` on `<OverflowMenu>` instead

### RadioButtonGroup

- This component has been updated from a class component to a functional
  component
- The `className` prop is now applied to the outermost element of
  `RadioButtonGroup`

### RadioTile

- The deprecated prop `iconDescription` is no longer needed and has been removed
- The `className` prop is now applied to the outermost element of `RadioTile`

### Search

- This component has been updated from a class component to a functional
  component
- The deprecated prop `placeHolderText` has been removed. Please use
  `placeholder` instead
- The deprecated prop `small` has been removed. Please use `size="sm"` instead
- The `size` prop values have been updated such that:
  - If using `size="lg"` in v10, use `size="md"`
  - If using `size="xl"` in v10, use `size="lg"`

### Select

- The deprecated prop `iconDescription` is no longer needed and has been removed
- The `size` prop has been updated to: `PropTypes.oneOf(['sm', 'md', 'lg'])`.
  The `xl` size is no longer supported
- The `className` prop is now applied to the outermost element of `Select`

### Slider

- This component has been updated from a class component to a functional
  component
- The deprecated prop `stepMuliplier` has been removed in favor of
  `stepMultiplier`
- The `className` prop is now applied to the outermost element of `Slider`
- The `ariaLabelInput` prop no longer has a default value and is now required

### StructuredListInput

- The `defaultChecked` prop is no longer needed and has been deprecated
- ~The `onChange` prop has been deprecated~ This was incorrectly marked as
  deprecated. `onChange` works and will remain in the StructuredListInput API.
- The `value` prop has been deprecated

### Table

- The deprecated prop `shouldShowBorder` has been removed
- The `size` prop has been updated to:
  `PropTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl'])`. Previous values such as
  `compact`, `short`, `normal`, `tall`, etc are no longer supported.

### TableToolbarSearch

- The deprecated prop `persistant` has been removed. Please use `persistent`
  instead.
- The deprecated prop `placeholderText` has been removed. Please use
  `placeholder` instead.

### TextInput

- The `className` prop is now applied to the outermost element of `TextInput`
- The `size` prop has been updated to: `PropTypes.oneOf(['sm', 'md', 'lg'])`.
  The `xl` size is no longer supported
- `TextInput.ControlledPasswordInput` is no longer available, use
  `ControlledPasswordInput` directly
- `TextInput.PasswordInput` is no longer available, use `PasswordInput` directly

### Tile

- This component has been updated from a class component to a functional
  component
- The `light` prop for Tile has been deprecated. For layering, please use the
  `Layer` component

### ClickableTile

- This component has been updated from a class component to a functional
  component
- The deprecated prop `handleClick` has been removed. Use `onClick` instead
- The deprecated prop `handleKeyDown` has been removed. use `onKeyDown` instead

### SelectableTile

- The deprecated prop `handleClick` has been removed. Use `onClick` instead
- The deprecated prop `handleKeyDown` has been removed. Use `onKeyDown` instead
- The deprecated prop `iconDescription` is no longer needed and has been removed
- The `light` prop for Tile has been deprecated. For layering, please use the
  `Layer` component

### ExpandableTile

- This component has been updated from a class component to a functional
  component
- The deprecated prop `handleClick` has been removed. Use `onClick` instead
- The `light` prop for Tile has been deprecated. For layering, please use the
  `Layer` component

### TimePicker

- This component has been updated from a class component to a functional
  component
- The `light` prop for Tile has been deprecated. For layering, please use the
  `Layer` component

### TimePickerSelect

- The deprecated `iconDescription` prop is no longer needed and has been removed
- The deprecated `hideLabel` prop has been removed

### Toggle

The toggle component has been updated to improve its accessibility, rtl
compatibility and flexibility to layout.

- The underlying element has been changed from a checkbox
  (`<input type="checkbox">`) to a switch button (`<button role="switch">`).
  - `props.onChange` has been removed since it's not available on `<button>`
    elements.
  - `props.onClick` has been added to substitute the previous `onChange` event.
- `props['aria-label']` is no longer required.
  - `props.labelText` will always be available to screen readers without the use
    of `aria-label`.
  - If `props['aria-label']` is still passed, it will be emitted on the
    `<button>` element.
- `props.hideLabel` has been added. This hides `labelA` and `labelB` while
  moving `labelText` to the side for height-restricted layouts.
- `props.labelA` and `props.labelB` have been made optional and default to "Off"
  and "On" respectively.

### Tabs

Tabs have been updated to be more composable so that you have the flexibility
and control to make them look and act how you want.

In v10, you may have code that looks like the following:

```js
<Tabs>
  <Tab label="Tab label 1">
    <p>Content for first tab goes here.</p>
  </Tab>
  <Tab label="Tab label 2">
    <p>Content for second tab goes here.</p>
  </Tab>
  <Tab label="Tab label 3" disabled>
    <p>Content for third tab goes here.</p>
  </Tab>
  <Tab
    label="Tab label 4 shows truncation"
    title="Tab label 4 shows truncation">
    <p>Content for fourth tab goes here.</p>
  </Tab>
</Tabs>
```

Those same Tabs, migrated to v11:

```js
<Tabs>
  <TabList>
    <Tab>Tab Label 1</Tab>
    <Tab>Tab Label 2</Tab>
    <Tab disabled>Tab Label 3</Tab>
    <Tab title="Tab Label 4 shows truncation">Tab Label 4 shows truncation</Tab>
  </TabList>
  <TabPanels>
    <TabPanel>Content for first tab goes here.</TabPanel>
    <TabPanel>Content for second tab goes here.</TabPanel>
    <TabPanel>Content for third tab goes here.</TabPanel>
    <TabPanel>Content for fourth tab goes here.</TabPanel>
  </TabPanels>
</Tabs>
```

### Update `Tabs` and `Tab` usage

All the same functionality for Tabs is available in v11 and more! However, some
props have been deprecated because they have either been renamed or are no
longer needed. Below are the minor tweaks in naming or implementation.

- the `type` prop is deprecated. Both "container" and "default" tabs still exist
  but now can be called by adding the prop `contained` to the `TabList`.
- Default tabs are now referred to as line tabs in our documentation here and in
  our storybook.
- `hidden` prop is no longer needed with the new composable Tabs. You have
  control over tab content and when it is hidden through the `TabPanel` and
  `TabPanels` components.
- `selected` prop is now named `selectedIndex`.
- `tabContentClassName` is no longer needed. `TabPanel` (equivalent to tab
  content) takes in a className prop on its outermost node.
- For `Tab`, `label` is no longer needed. `children` of `Tab` are now the label.
- Due to its composability, `renderAnchor`, `renderButton`, `renderContent` are
  no longer needed on `Tab`. You now have full control over what is rendered
  inside of `Tab` and `TabPanel`.
- Because `renderButton` is no longer needed, the associated `tabIndex` prop has
  also been deprecated.
- `selected` on `Tab` is deprecated in favor or `selectedIndex`, now placed on
  `Tabs` instead.

For more details about the changes to Tabs, see our storybook documentation
[here](https://react.carbondesignsystem.com/?path=/docs/components-tabs--default).

### Tooltips

Starting in v11, the `Tooltip`, `TooltipDefinition`, and `TooltipIcon`
components have been updated in order to be made accessible. In particular,

- The API of Tooltip has been updated. This component should not include
  interactive content
- TooltipDefinition has been renamed to DefinitionTooltip
- TooltipIcon has been removed, use `IconButton` instead

For interactive content use-cases inside of Tooltips, we have introduced a new
component: `Toggletip`.

#### Tooltip

This component has been updated so that it will add a tooltip to any interactive
child element that is passed to this component. For example:

```jsx
import { Tooltip } from '@carbon/react';

function ExampleComponent() {
  return (
    <Tooltip label="Close">
      <button type="button">X</button>
    </Tooltip>
  );
}
```

This component accepts two ways to specify the content of the tooltip: `label`
and `description`. These components accept either a string or a component and
they must not contain interactive content. If you have a tooltip which contains
interactive content, use a Toggletip instead.

As a result of these changes, certain props are no longer applicable in v11,
including:

- focusTrap: this component no longer requires this behavior
- iconName
- menuOffset
- renderIcon: this is now the content of Tooltip
- selectorPrimaryFocus: this component no longer requires this behavior
- showIcon: this is now controlled by the children of Tooltip
- tooltipBodyId: this component no longer requires this behavior
- tooltipId: this component no longer requires this behavior
- triggerClassName: this is now controlled by the children of Tooltip
- triggerText
- iconDescription: this is now replaced by `label` or `description`

Certain props are not available in v11 but will be available soon. For example,
`autoOrientation` will be available under `align="auto"`.

In addition, the `align` and `direction` props have been updated to a single
prop: `align`.

For full documentation on this component, check out our
[Storybook](https://react.carbondesignsystem.com/?path=/story/components-tooltip--default)

#### TooltipDefinition

This component has been renamed to `DefinitionTooltip`. There are two notable
changes to this component:

- The `tooltipText` prop has been renamed to `definition`
- The `align` and `direction` props have been merged into the `align` prop

For full documentation on this component, check out our
[Storybook](https://react.carbondesignsystem.com/?path=/story/components-definitiontooltip--default)

#### TooltipIcon

This component was problematic in v10 because the tooltip was being added to an
element that was not interactive. In order to ship an accessible version of this
component, we now have an `IconButton` component that can be used as a
replacement for `TooltipIcon`. If you have a situation where your content is not
related to a button or action, please reach out! We'll help you find a good way
to migrate your work in v10.

As a result, in places where you are using `TooltipIcon` you can use
`IconButton`.

**Before**

```jsx
import { TooltipIcon } from 'carbon-components-react';

function ExampleComponent() {
  return (
    <TooltipIcon
      tooltipText="Example tooltip"
      onClick={() => {
        // ...
      }}
      renderIcon={Filter}
    />
  );
}
```

**After**

```jsx
import { IconButton } from '@carbon/react';

function ExampleComponent() {
  return (
    <IconButton
      label="Example tooltip"
      onClick={() => {
        // ...
      }}>
      <Filter />
    </IconButton>
  );
}
```

With this update, certain props are no longer needed or have been renamed. These
include:

- `align` and `direction` have been merged into `align`
- `renderIcon` this is now whatever you render as the child of `IconButton`
- `tooltipText` this has been renamed to `label`

For full documentation on this component, check out our
[Storybook](https://react.carbondesignsystem.com/?path=/story/components-iconbutton--playground)

## carbon-icons

The `carbon-icons` package has been deprecated and is no longer supported. To
use icons from the Carbon Design System, you should install the appropriate
library to use with your framework:

| Package                 | Framework          | Link                                                    |
| :---------------------- | :----------------- | :------------------------------------------------------ |
| `@carbon/icons-react`   | React              | [Link](https://npmjs.com/package/@carbon/icons-react)   |
| `@carbon/icons-angular` | Angular            | [Link](https://npmjs.com/package/@carbon/icons-angular) |
| `@carbon/icons-vue`     | Vue                | [Link](https://npmjs.com/package/@carbon/icons-vue)     |
| `carbon-icons-svelte`   | Svelte             | [Link](https://npmjs.com/package/carbon-icons-svelte)   |
| `@carbon/icons`         | Vanilla JavaScript | [Link](https://npmjs.com/package/@carbon/icons)         |

## @carbon/icons

**Changes**

- The `scss` directory which provided styles is no longer provided through this
  package
- The following assets that were deprecated in v10 have been removed:
  - app-switcher
  - arrows
  - back-to-top
  - checkbox--undeterminate
  - checkbox--undeterminate--filled
  - cloud--lightning
  - cloud--rain
  - cloud--snow
  - delete
  - edit-filter
  - sunny
  - research--bloch-sphere
  - research--hinton-plot
  - research--matrix
  - misuse--alt
  - logo--google
  - mammogram--stacked
  - logo--delicious
  - logo--stumbleupon
  - letter--Aa--large
  - glyph--caution-inverted
  - glyph--caution
  - glyph--circle-fill
  - glyph--circle-stroke
  - glyph--critical
  - glyph--incomplete
  - glyph--square-fill
  - glyph--undefined

## @carbon/icons-react

The `@carbon/icons-react` package has been updated to minimize the number of
exports from the package to help reduce build and compile times. It also has
been updated to remove icons that were deprecated in v10.

_If you are using `@carbon/react`, you can now import icons directly from
`@carbon/react/icons`._

### Changes to size

This update includes a change to the API of the icon components that come from
this package. Previously, we would export icons that included the size of the
asset. This update allows you to bring the icon directly and specify the size
using the `size` prop.

**Before**

```jsx
import { Add32, Add24, Add20, Add16 } from '@carbon/icons-react';

function MyComponent() {
  return (
    <>
      <Add32 />
      <Add24 />
      <Add20 />
      <Add16 />
    </>
  );
}
```

**After**

```jsx
import { Add } from '@carbon/icons-react';

function MyComponent() {
  return (
    <>
      <Add size={32} />
      <Add size={24} />
      <Add size={20} />
      <Add />
    </>
  );
}
```

### Removed icons

The following deprecated icons have been removed. Use the table below to find
their replacement, if available, in v11.

| Asset                           | v10                         | v11                         |
| :------------------------------ | :-------------------------- | :-------------------------- |
| app-switcher                    | AppSwitcher                 | Switcher                    |
| arrows                          | Arrows                      | ArrowsVertical              |
| back-to-top                     | BackToTop                   | UpToTop                     |
| checkbox--undeterminate         | CheckboxUndeterminate       | CheckboxIndeterminate       |
| checkbox--undeterminate--filled | CheckboxUndeterminateFilled | CheckboxIndeterminateFilled |
| cloud--lightning                | CloudLightning              | Removed                     |
| cloud--rain                     | CloudRain                   | Removed                     |
| cloud--snow                     | CloudSnow                   | Removed                     |
| delete                          | Delete                      | TrashCan                    |
| edit-filter                     | EditFilter                  | FilterEdit                  |
| sunny                           | Sunny                       | Removed                     |
| research--bloch-sphere          | ResearchBlockSphere         | BlochSphere                 |
| research--hinton-plot           | ResearchHintonPlot          | HintonPlot                  |
| research--matrix                | ResearchMatrix              | Matrix                      |
| misuse--alt                     | MisuseAlt                   | MisuseOutline               |
| logo--google                    | LogoGoogle                  | Removed                     |
| mammogram--stacked              | MammogramStacked            | Removed                     |
| logo--delicious                 | LogoDelicious               | Removed                     |
| logo--stumbleupon               | LogoStumbleUpon             | Removed                     |
| letter--Aa--large               | LetterAaLarge               | TextFont                    |
| glyph--caution-inverted         | GlyphCautionInverted        | CautionInverted             |
| glyph--caution                  | GlyphCaution                | Caution                     |
| glyph--circle-fill              | GlyphCircleFill             | CircleFill                  |
| glyph--circle-stroke            | GlyphCircleStroke           | CircleStroke                |
| glyph--critical                 | GlyphCritical               | Critical                    |
| glyph--incomplete               | GlyphIncomplete             | Incomplete                  |
| glyph--square-fill              | GlyphSquareFill             | SquareFill                  |
| glyph--undefined                | GlyphUndefined              | Undefined                   |

### Migration

Most use-cases of the icons from the `@carbon/icons-react` package will be
covered by automated codemods. To run these codemods, follow the instructions in
[`@carbon/upgrade`](../../packages/upgrade/README.md).

#### Update imports and size usage for @carbon/icons-react

```bash
npx @carbon/upgrade migrate icons-react-size-prop --write
```

### Rewrite imports from `@carbon/icons-react` to `@carbon/react/icons`.

If you are using `@carbon/react`, you can now import icons directly from
`@carbon/react/icons`.

```bash
npx @carbon/upgrade migrate update-carbon-icons-react-import-to-carbon-react --write
```

Note: be sure to run this codemod _after `icons-react-size-prop`_.

#### Troubleshooting automated codemod migration

However, in certain situations, we will be unable to infer what the correct
update should be for a certain usage of the icon component. We have written the
codemod to work for most situations, but you will see console warnings for files
that will require you to manually review them to make sure the transforms were
applied correctly.

The most common manual update that teams will need to make is if a `prop` where
the icon is passed to places a `ref` on the icon. For example,

```jsx
function MyComponent({ renderIcon: Icon }) {
  const ref = useRef(null);
  return <Icon ref={ref} />;
}

// Before
<MyComponent renderIcon={Search16} />

// After the codemod
<MyComponent renderIcon={props => <Search size={16} {...props} />} />
```

In this situation, you will need to update your code to use `React.forwardRef`:

```jsx
<MyComponent
  renderIcon={React.forwardRef((props, ref) => (
    <Search ref={ref} size={16} {...props} />
  ))}
/>;

// Or, alternatively:
const Search16 = React.forwardRef((props, ref) => {
  return <Search ref={ref} size={16} {...props} />;
});

<MyComponent renderIcon={Search16} />;
```

### Manual migration

In addition to the automated codemods above, there are several patterns in your
codebase that you will need to update manually:

- If you use the name `ForwardRef(IconName16)` in a test you will need to
  manually change this. Prefer to use the component directly if using enzyme
- If you use snapshot tests, the structure will change and include a `size`
  prop. Make sure that the `size` prop value matches what your icon name used to
  be. For example, `<Add16 />` should become `<Add size={16} />`

#### Component definition is missing display name

If you use `eslint` you may run into the error message above. This comes from
the `react/display-rule` rule. It comes as a result of the transform changing
the following code:

```jsx
// Input
const iconTypes = {
  add: Add32,
};

// Output
const iconTypes = {
  add: (props) => <Add size={32} {...props} />,
};
```

The transform will create an inline arrow function expression and as a result it
does not have a `displayName` like if you created this function using a variable
or function declaration.

To address this issue, you can manually create the component:

```jsx
const Add32 = (props) => <Add size={32} {...props} />;
const iconTypes = {
  add: Add32,
};
```

## @carbon/colors

The v10.x versions of this package reached end of support on September 30, 2024
and will not receive any more updates.

**Breaking changes**

- This package now requires Dart Sass and uses Sass Modules
- The `scss` folder is no longer needed, you can import `@carbon/colors`
  directly in Sass
- Variables and mixins with the `ibm--` prefix have been removed
- Variables and mixins with the `carbon--` prefix have been removed

**Imports**

| v10                                     | v11                                  |
| :-------------------------------------- | :----------------------------------- |
| `@import '@carbon/colors/scss/index';`  | `@use '@carbon/colors';`             |
|                                         | `@use '@carbon/react/scss/colors';`  |
|                                         | `@use '@carbon/styles/scss/colors';` |
| `@import '@carbon/colors/scss/colors';` | `@use '@carbon/colors';`             |
|                                         | `@use '@carbon/react/scss/colors';`  |
|                                         | `@use '@carbon/styles/scss/colors';` |

**Sass API**

| v10                                                     | v11                                       |
| :------------------------------------------------------ | :---------------------------------------- |
| `$<swatch>-<grade>`, for example `$blue-50`             | No changes                                |
| `$<swatch>-<grade>-hover`, for example `$blue-50-hover` | No changes                                |
| `$ibm-color__<swatch>-<grade>`                          | Removed, use `$<swatch>-<grade>` directly |
| `$ibm-color-map`                                        | Removed, replaced by `$colors`            |
| `@mixin ibm--colors`                                    | Removed                                   |
| `$carbon--<swatch>-<grade>`                             | Removed, use `$<swatch>-<grade>` directly |
| `$carbon--colors`                                       | Removed, replaced by `$colors`            |
| `@mixin carbon--colors`                                 | Removed                                   |

For full Sass API documentation, visit the
[Sass Documentation](../../packages/colors/docs/sass.md) for this package.

**JavaScript API**

| v10      | v11                                                                                                |
| :------- | :------------------------------------------------------------------------------------------------- |
| `yellow` | This variable no longer refers to a color and instead refers to the swatch. Use `yellow30` instead |
| `orange` | This variable no longer refers to a color and instead refers to the swatch. Use `orange40` instead |

## @carbon/elements

The v10.x versions of this package reached end of support on September 30, 2024
and will not receive any more updates.

**Breaking changes**

- This package now requires Dart Sass and uses Sass Modules
- The `scss` folder is no longer needed, you can import `@carbon/elements`
  directly in Sass

**Imports**

| v10                                         | v11                        |
| :------------------------------------------ | :------------------------- |
| `@import '@carbon/elements/scss/index';`    | `@use '@carbon/elements';` |
| `@import '@carbon/elements/scss/elements';` | `@use '@carbon/elements';` |

**Sass API**

This package re-exports from other packages that make up the IBM Design
Language. For more information about exports, refer to the individual package
documentation to see what has changed. These packages include:

- [@carbon/colors](#carboncolors)
- [@carbon/grid](#carbongrid)
- [@carbon/layout](#carbonlayout)
- [@carbon/motion](#carbonmotion)
- [@carbon/themes](#carbonthemes)
- [@carbon/type](#carbontype)

For full Sass API documentation, visit the
[Sass Documentation](../../packages/elements/docs/sass.md) for this package.

## @carbon/grid

The v10.x versions of this package reached end of support on September 30, 2024
and will not receive any more updates.

| v10                                 | v11                                |
| :---------------------------------- | :--------------------------------- |
| `@import '@carbon/grid/scss/grid';` | `@use '@carbon/grid';`             |
| (alias)                             | `@use '@carbon/styles/scss/grid';` |
| (alias)                             | `@use '@carbon/react/scss/grid';`  |

**Changes**

- This package now requires Dart Sass and uses Sass Modules
- The default number of columns has been changed to 16
- The grid package has been updated to include a CSS Grid implementation of the
  grid
  - This include supports for subgrid in CSS Grid
- Variables, mixins, and functions with the `carbon--` prefix have been renamed

| Filename               | v10                       | v11                                                                                          |
| ---------------------- | ------------------------- | -------------------------------------------------------------------------------------------- |
| `scss/grid.scss`       |                           | Moved to `index.scss`                                                                        |
| `scss/index.scss`      |                           | Moved to `index.scss`                                                                        |
| `scss/_breakpoint`     |                           | New, this has moved from `@carbon/layout`                                                    |
|                        | `$grid-gutter--condensed` | `$grid-gutter`                                                                               |
| `scss/_css-grid.scss`  |                           | New                                                                                          |
| `scss/_flex-grid.scss` |                           | New                                                                                          |
| `scss/_mixins.scss`    |                           | Moved to `scss/_flex-grid.scss`                                                              |
|                        | `$carbon--aspect-ratios`  | Moved to `@carbon/styles/scss/components/aspect-ratio`                                       |
|                        | `carbon--grid`            | Renamed to `@mixin flex-grid`                                                                |
| `scss/_prefix.scss`    |                           | Moved to `scss/_config.scss` under `$prefix`                                                 |
| `scss/12.scss`         |                           | This file has been removed, configure `$flex-grid-columns` to 12 to emulate this entry point |

For full documentation, visit the
[Sass Documentation](../../packages/grid/docs/sass.md) for the package.

## @carbon/layout

The v10.x versions of this package reached end of support on September 30, 2024
and will not receive any more updates.

**Breaking changes**

- This package now requires Dart Sass and uses Sass Modules
- Variables, mixins, and functions using the `carbon--` prefix has been renamed
- The layout scale has been replaced with steps in the spacing scale
- Breaking and grid functions, mixins, and variables have been moved to the
  `@carbon/grid` package

**Imports**

| v10                                     | v11                                   |
| :-------------------------------------- | :------------------------------------ |
| `@import '@carbon/layout/scss/layout';` | `@use '@carbon/layout';`              |
|                                         | `@use '@carbon/styles/scss/spacing';` |
|                                         | `@use '@carbon/react/scss/spacing';`  |
| `@import '@carbon/layout/scss/index';`  | `@use '@carbon/layout';`              |
|                                         | `@use '@carbon/styles/scss/spacing';` |
|                                         | `@use '@carbon/react/scss/spacing';`  |

**Changes**

| Filename                | v10                                  | v11                                                                                                                            |
| :---------------------- | :----------------------------------- | :----------------------------------------------------------------------------------------------------------------------------- |
| `scss/_breakpoint.scss` |                                      | Moved to `@carbon/grid`, use directly from package or from `@carbon/styles/scss/breakpoint` or `@carbon/react/scss/breakpoint` |
| `scss/_convert.scss`    | `$carbon--base-font-size`            | Renamed to `$base-font-size`                                                                                                   |
|                         | `@function carbon--rem`              | Renamed to `@function rem`                                                                                                     |
|                         | `@function carbon--em`               | Renamed to `@function em`                                                                                                      |
| `scss/_key-height.scss` | `@function carbon--get-column-width` | Removed                                                                                                                        |
|                         | `$carbon--key-height-scales`         | Removed                                                                                                                        |
|                         | `@function carbon--key-height`       | Removed                                                                                                                        |
| `scss/_mini-unit.scss`  | `$carbon--mini-unit-size`            | Removed                                                                                                                        |
|                         | `@function carbon--mini-units`       | Removed                                                                                                                        |
| `scss/_spacing.scss`    | `$carbon--spacing-01`                | Removed, use `$spacing-01` instead                                                                                             |
|                         | `$carbon--spacing-02`                | Removed, use `$spacing-02` instead                                                                                             |
|                         | `$carbon--spacing-03`                | Removed, use `$spacing-03` instead                                                                                             |
|                         | `$carbon--spacing-04`                | Removed, use `$spacing-04` instead                                                                                             |
|                         | `$carbon--spacing-05`                | Removed, use `$spacing-05` instead                                                                                             |
|                         | `$carbon--spacing-06`                | Removed, use `$spacing-06` instead                                                                                             |
|                         | `$carbon--spacing-07`                | Removed, use `$spacing-07` instead                                                                                             |
|                         | `$carbon--spacing-08`                | Removed, use `$spacing-08` instead                                                                                             |
|                         | `$carbon--spacing-09`                | Removed, use `$spacing-09` instead                                                                                             |
|                         | `$carbon--spacing-10`                | Removed, use `$spacing-10` instead                                                                                             |
|                         | `$carbon--spacing-11`                | Removed, use `$spacing-11` instead                                                                                             |
|                         | `$carbon--spacing-12`                | Removed, use `$spacing-12` instead                                                                                             |
|                         | `$carbon--spacing-13`                | Removed, use `$spacing-13` instead                                                                                             |
|                         | `$carbon--spacing`                   | Removed, use `$spacing` instead                                                                                                |
|                         | `$spacing-01`                        | No changes                                                                                                                     |
|                         | `$spacing-02`                        | No changes                                                                                                                     |
|                         | `$spacing-03`                        | No changes                                                                                                                     |
|                         | `$spacing-04`                        | No changes                                                                                                                     |
|                         | `$spacing-05`                        | No changes                                                                                                                     |
|                         | `$spacing-06`                        | No changes                                                                                                                     |
|                         | `$spacing-07`                        | No changes                                                                                                                     |
|                         | `$spacing-08`                        | No changes                                                                                                                     |
|                         | `$spacing-09`                        | No changes                                                                                                                     |
|                         | `$spacing-10`                        | No changes                                                                                                                     |
|                         | `$spacing-11`                        | No changes                                                                                                                     |
|                         | `$spacing-12`                        | No changes                                                                                                                     |
|                         | `$spacing-13`                        | No changes                                                                                                                     |
|                         | `$carbon--layout-01`                 | Removed, use `$spacing-05` instead                                                                                             |
|                         | `$carbon--layout-02`                 | Removed, use `$spacing-06` instead                                                                                             |
|                         | `$carbon--layout-03`                 | Removed, use `$spacing-07` instead                                                                                             |
|                         | `$carbon--layout-04`                 | Removed, use `$spacing-09` instead                                                                                             |
|                         | `$carbon--layout-05`                 | Removed, use `$spacing-10` instead                                                                                             |
|                         | `$carbon--layout-06`                 | Removed, use `$spacing-12` instead                                                                                             |
|                         | `$carbon--layout-07`                 | Removed, use `$spacing-13` instead                                                                                             |
|                         | `$carbon--layout`                    | Removed                                                                                                                        |
|                         | `$layout-01`                         | Removed, use `$spacing-05` instead                                                                                             |
|                         | `$layout-02`                         | Removed, use `$spacing-06` instead                                                                                             |
|                         | `$layout-03`                         | Removed, use `$spacing-07` instead                                                                                             |
|                         | `$layout-04`                         | Removed, use `$spacing-09` instead                                                                                             |
|                         | `$layout-05`                         | Removed, use `$spacing-10` instead                                                                                             |
|                         | `$layout-06`                         | Removed, use `$spacing-12` instead                                                                                             |
|                         | `$layout-07`                         | Removed, use `$spacing-13` instead                                                                                             |
|                         | `$carbon--fluid-spacing-01`          | Removed, use `$fluid-spacing-01` instead                                                                                       |
|                         | `$carbon--fluid-spacing-02`          | Removed, use `$fluid-spacing-02` instead                                                                                       |
|                         | `$carbon--fluid-spacing-03`          | Removed, use `$fluid-spacing-03` instead                                                                                       |
|                         | `$carbon--fluid-spacing-04`          | Removed, use `$fluid-spacing-04` instead                                                                                       |
|                         | `$carbon--fluid-spacing`             | Removed, use `$fluid-spacing` instead                                                                                          |
|                         | `$fluid-spacing-01`                  | No changes                                                                                                                     |
|                         | `$fluid-spacing-02`                  | No changes                                                                                                                     |
|                         | `$fluid-spacing-03`                  | No changes                                                                                                                     |
|                         | `$fluid-spacing-04`                  | No changes                                                                                                                     |
|                         | `$fluid-spacing`                     | No changes                                                                                                                     |

For full documentation, visit the
[Sass Documentation](../../packages/layout/docs/sass.md) for the package.

**JavaScript API**

- The layout exports have been removed, use the spacing exports instead

| v10        | v11         |
| :--------- | :---------- |
| `layout01` | `spacing05` |
| `layout02` | `spacing06` |
| `layout03` | `spacing07` |
| `layout04` | `spacing09` |
| `layout05` | `spacing10` |
| `layout06` | `spacing12` |
| `layout07` | `spacing13` |
| `layout`   | Removed     |

## @carbon/motion

The v10.x versions of this package reached end of support on September 30, 2024
and will not receive any more updates.

**Breaking changes**

- This package now requires Dart Sass and uses Sass Modules
- The `scss` folder is no longer needed, you can import `@carbon/motion`
  directly in Sass
- Variables, mixins, and functions using the `carbon--` prefix has been renamed
- Duration variables now have a `duration-` prefix

**Imports**

| v10                                     | v11                                  |
| :-------------------------------------- | :----------------------------------- |
| `@import '@carbon/motion/scss/motion';` | `@use '@carbon/motion';`             |
|                                         | `@use '@carbon/styles/scss/motion';` |
|                                         | `@use '@carbon/react/scss/motion';`  |
| `@import '@carbon/motion/scss/index';`  | `@use '@carbon/motion';`             |
|                                         | `@use '@carbon/styles/scss/motion';` |
|                                         | `@use '@carbon/react/scss/motion';`  |

**Sass API**

| v10                        | v11                                |
| -------------------------- | ---------------------------------- |
| `$fast-01`                 | Renamed to `$duration-fast-01`     |
| `$fast-02`                 | Renamed to `$duration-fast-02`     |
| `$moderate-01`             | Renamed to `$duration-moderate-01` |
| `$moderate-02`             | Renamed to `$duration-moderate-02` |
| `$slow-01`                 | Renamed to `$duration-slow-01`     |
| `$slow-02`                 | Renamed to `$duration-slow-02`     |
| `$carbon--easings`         | Renamed to `$easings`              |
| `@function carbon--motion` | Renamed to `@function motion`      |
| `@mixin carbon--motion`    | Renamed to `@mixin motion`         |

For full documentation, visit the
[Sass Documentation](../../packages/motion/docs/sass.md) for the package.

## @carbon/themes

The v10.x versions of this package reached end of support on September 30, 2024
and will not receive any more updates.

**Breaking changes**

- This package now requires Dart Sass and uses Sass Modules
- Variables, mixins, and functions with the `carbon--` prefix have been renamed
- Design Tokens have been changed, however you can use the
  [compatibility docs](#compatibility) to use v10 tokens along with v11 tokens
- The `theme` mixin now emits CSS Custom Properties by default for the given
  theme, `$emit-custom-properties` and `$emit-difference` are no longer needed

**Imports**

| v10                                         | v11                                  |
| :------------------------------------------ | :----------------------------------- |
| `@import '@carbon/themes/scss/themes';`     | `@use '@carbon/themes';`             |
|                                             | `@use '@carbon/styles';`             |
|                                             | `@use '@carbon/react/scss/themes';`  |
| `@import '@carbon/themes/scss/index';`      | `@use '@carbon/themes';`             |
|                                             | `@use '@carbon/styles/scss/theme';`  |
|                                             | `@use '@carbon/react/scss/theme';`   |
| `@import '@carbon/themes/scss/theme-maps';` | `@use '@carbon/themes/scss/themes';` |
|                                             | `@use '@carbon/styles/scss/themes';` |
|                                             | `@use '@carbon/react/scss/themes';`  |

**Sass API**

| Filename                | v10                     | v11                                                                                                |
| ----------------------- | ----------------------- | -------------------------------------------------------------------------------------------------- |
| `scss/_mixins.scss`     |                         | Moved to `scss/theme`                                                                              |
|                         | `@mixin carbon--theme`  | Renamed to `@mixin theme`                                                                          |
| `scss/_theme-maps.scss` |                         | Moved to `scss/themes`                                                                             |
|                         | `$carbon--theme--white` | Renamed to `$white`                                                                                |
|                         | `$carbon--theme--g10`   | Renamed to `$g10`                                                                                  |
|                         | `$carbon--theme--g90`   | Renamed to`$g90`                                                                                   |
|                         | `$carbon--theme--g100`  | Renamed `$g100`                                                                                    |
| `scss/_tokens.scss`     |                         | Tokens have been changed, use the compatibility theme or switch to the [new tokens](#designtokens) |
| `scss/themes.scss`      |                         | Moved to `@carbon/themes`                                                                          |
| `scss/index.scss`       |                         | Moved to `@carbon/themes`                                                                          |

For full Sass API documentation, visit the
[Sass Documentation](../../packages/themes/docs/sass.md) for this package.

**JavaScript API**

| v10           | v11                                                                                                 |
| :------------ | :-------------------------------------------------------------------------------------------------- |
| Token exports | The names and values of tokens have been updated in v11. Access v10 values through the `v10` export |
| `white`       | Updated with new tokens and values. For the v10 white theme, use the `v10` export                   |
| `g10`         | Updated with new tokens and values. For the v10 g10 theme, use the `v10` export                     |
| `g80`         | Removed                                                                                             |
| `g90`         | Updated with new tokens and values. For the v10 g90 theme, use the `v10` export                     |
| `g100`        | Updated with new tokens and values. For the v10 g100 theme, use the `v10` export                    |
| `v9`          | Removed                                                                                             |
| `themes`      | Updated with new tokens and values. For the v10 themes, use the `v10` export                        |

The `v10` export has been added to access old token and theme values. To access
the v10 version of a theme, you can use this export directly:

```js
import { v10 } from '@carbon/themes';

const { white, g10, g90, g100 } = v10;
```

### Design Tokens

**Status key:**

- **No change:** Token name has no change between versions.
- **Updated:** From v10 to V11 the number suffix has been replaced with an
  adjective that reflects it's usage. This is just a name change, the role
  remains the same between v10 and v11.
- **Split:** V10 token has been split into multiple new v11 tokens for more
  specific usage.
- **New:** A net new color token to the system in v11. It has no v10
  counterpart.
- **Deprecated:** v10 token was removed in v11.

V11 introduces the idea of
[component tokens](https://github.com/carbon-design-system/carbon/blob/main/packages/styles/docs/sass.md#component-tokens)
for tokens specific to a particular component; for example button, tag or
notification. If you'd like to use these component tokens in your stylesheet,
you'll need to `@use` them:

```scss
@use '@carbon/styles/scss/components/button';

.my-selector {
  background: button.$button-primary;
}
```

Read more about using or customizing
[component tokens](https://github.com/carbon-design-system/carbon/blob/main/packages/styles/docs/sass.md#component-tokens).

| V10 token name     | V11 token name            | V11 Contextual token   | Status     |
| ------------------ | ------------------------- | ---------------------- | ---------- |
| active-danger      | button-danger-active      | —                      | Updated    |
| active-light-ui    | layer-active-02           | layer-active           | Updated    |
| active-primary     | button-primary-active     | —                      | Updated    |
| active-secondary   | button-secondary-active   | —                      | Updated    |
| active-tertiary    | button-tertiary-active    | —                      | Updated    |
| active-ui          | layer-active-01           | layer-active           | Split      |
| active-ui          | background-active         | —                      | Split      |
| active-ui          | layer-accent-active-01    | layer-accent-active    | Split      |
| active-ui          | border-subtle-selected-01 | border-subtle-selected | Split      |
| button-separator   | button-separator          | —                      | No change  |
| danger             | button-danger-primary     | —                      | Deprecated |
| danger-01          | button-danger-primary     | —                      | Updated    |
| danger-02          | button-danger-secondary   | —                      | Updated    |
| decorative-01      | border-subtle-02          | border-subtle          | Updated    |
| disabled-01        | —                         | —                      | Deprecated |
| disabled-02        | text-disabled             | —                      | Split      |
| disabled-02        | icon-disabled             | —                      | Split      |
| disabled-02        | button-disabled           | —                      | Split      |
| disabled-02        | border-disabled           | border-disabled        | Split      |
| disabled-03        | icon-on-color-disabled    | —                      | Split      |
| disabled-03        | layer-selected-disabled   | —                      | Split      |
| disabled-03        | text-on-color-disabled    | —                      | Split      |
| field-01           | field-01                  | field                  | No change  |
| field-02           | field-02                  | field                  | No change  |
| focus              | focus                     | —                      | No change  |
| highlight          | highlight                 | —                      | No change  |
| hover-danger       | button-danger-hover       | —                      | Updated    |
| hover-light-ui     | layer-hover-02            | —                      | Updated    |
| hover-primary      | button-primary-hover      | —                      | Updated    |
| hover-primary-text | link-primary-hover        | —                      | Updated    |
| hover-secondary    | button-secondary-hover    | —                      | Updated    |
| hover-selected-ui  | background-selected-hover | —                      | Split      |
| hover-selected-ui  | layer-accent-hover-01     | layer-accent-hover     | Split      |
| hover-selected-ui  | layer-selected-hover-01   | layer-selected-hover   | Split      |
| hover-tertiary     | button-tertiary-hover     | —                      | Updated    |
| hover-ui           | background-hover          | —                      | Updated    |
| hover-ui           | layer-hover-01            | layer-hover            | Split      |
| hover-ui           | field-hover-01            | field-hover            | Split      |
| hover-ui           | field-hover-02            | field-hover            | Split      |
| icon-01            | icon-primary              | —                      | Updated    |
| icon-02            | icon-secondary            | —                      | Updated    |
| icon-03            | icon-on-color             | —                      | Updated    |
| interactive-01     | button-primary            | —                      | Updated    |
| interactive-01     | background-brand          | —                      | Updated    |
| interactive-02     | button-secondary          | —                      | Updated    |
| interactive-03     | button-tertiary           | —                      | Updated    |
| interactive-04     | border-interactive        | —                      | Split      |
| interactive-04     | interactive               | —                      | Split      |
| inverse-01         | icon-inverse              | —                      | Split      |
| inverse-01         | focus-inset               | —                      | Split      |
| inverse-01         | text-inverse              | —                      | Split      |
| inverse-02         | background-inverse        | —                      | Updated    |
| inverse-focus-ui   | focus-inverse             | —                      | Updated    |
| inverse-hover-ui   | background-inverse-hover  | —                      | Updated    |
| inverse-link       | link-inverse              | —                      | Updated    |
| inverse-support-01 | support-error-inverse     | —                      | Updated    |
| inverse-support-02 | support-success-inverse   | —                      | Updated    |
| inverse-support-03 | support-warning-inverse   | —                      | Updated    |
| inverse-support-04 | support-info-inverse      | —                      | Updated    |
| link-01            | link-primary              | —                      | Updated    |
| link-02            | link-secondary            | —                      | Updated    |
| overlay-01         | overlay                   | —                      | Updated    |
| selected-light-ui  | layer-selected-02         | —                      | Updated    |
| selected-ui        | layer-selected-01         | layer-selected         | Split      |
| selected-ui        | background-selected       | —                      | Split      |
| skeleton-01        | skeleton-background       | —                      | Updated    |
| skeleton-02        | skeleton-element          | —                      | Updated    |
| support-01         | support-error             | —                      | Updated    |
| support-02         | support-success           | —                      | Updated    |
| support-03         | support-warning           | —                      | Updated    |
| support-04         | support-info              | —                      | Updated    |
| text-01            | text-primary              | —                      | Updated    |
| text-02            | text-secondary            | —                      | Updated    |
| text-03            | text-placeholder          | —                      | Updated    |
| text-04            | text-on-color             | —                      | Updated    |
| text-05            | text-helper               | —                      | Updated    |
| text-error         | text-error                | —                      | Updated    |
| hover-row          | layer-hover-01            | layer-hover            | Deprecated |
| ui-01              | layer-01                  | layer                  | Updated    |
| ui-02              | layer-02                  | layer                  | Updated    |
| ui-03              | layer-accent-01           | layer-accent           | Split      |
| ui-03              | border-subtle-01          | border-subtle          | Split      |
| ui-04              | toggle-off                | —                      | Split      |
| ui-04              | border-strong-01          | border-strong          | Split      |
| ui-05              | border-inverse            | —                      | Updated    |
| ui-05              | layer-selected-inverse    | —                      | Updated    |
| ui-background      | background                | —                      | Updated    |
| visited-link       | link-visited              | —                      | Updated    |
| brand-01           | —                         | —                      | Deprecated |
| brand-02           | —                         | —                      | Deprecated |
| brand-03           | —                         | —                      | Deprecated |
| —                  | border-strong-02          | border-strong          | New        |
| —                  | border-strong-03          | border-strong          | New        |
| —                  | border-subtle-00          | border-subtle          | New        |
| —                  | border-subtle-03          | border-subtle          | New        |
| —                  | border-subtle-selected-02 | border-subtle-selected | New        |
| —                  | border-subtle-selected-03 | border-subtle-selected | New        |
| —                  | field-03                  | field                  | New        |
| —                  | field-hover-03            | field-hover            | New        |
| —                  | layer-03                  | layer                  | New        |
| —                  | layer-active-03           | layer-active           | New        |
| —                  | layer-hover-03            | layer-hover            | New        |
| —                  | layer-selected-03         | layer-selected         | New        |
| —                  | layer-selected-hover-02   | layer-selected-hover   | New        |
| —                  | layer-selected-hover-03   | layer-selected-hover   | New        |
| —                  | layer-accent-02           | layer-accent           | New        |
| —                  | layer-accent-03           | layer-accent           | New        |
| —                  | layer-accent-active-02    | layer-accent-active    | New        |
| —                  | layer-accent-active-03    | layer-accent-active    | New        |
| —                  | layer-accent-hover-02     | layer-accent-hover     | New        |
| —                  | layer-accent-hover-03     | layer-accent-hover     | New        |

### Compatibility

To make it easier to move between v10 and v11 of Carbon, we've introduced a
compatibility theme that includes the tokens from v10 and v11 so that you can
incrementally update your project.

You can use a "compatibility theme" by setting the `$fallback` to a value from
`scss/compat/themes`. For example:

```scss
@use '@carbon/react/scss/compat/themes' as compat;
@use '@carbon/react/scss/themes';
@use '@carbon/react/scss/theme' with (
  $fallback: compat.$g100,
  $theme: themes.$g100
);
@use '@carbon/react';

:root {
  @include theme.theme();
}
```

In this code snippet, we set the current theme to `$g100` and include the
compatibility theme for `$g100` as the `$fallback.

## @carbon/type

The v10.x versions of this package reached end of support on September 30, 2024
and will not receive any more updates.

**Breaking changes**

- This package now requires Dart Sass and uses Sass Modules
- The `scss` folder is no longer needed, you can import `@carbon/type` directly
  in Sass
- Variables, mixins, and functions with the `carbon--` prefix have been renamed

**Imports**

All imports in v11 have been replaced by `@carbon/type`. For example, if you
were importing `@carbon/type/scss/styles` in v10 you would now only import
`@carbon/type` and use exports from that module directly.

| v10                              | v11                                |
| :------------------------------- | :--------------------------------- |
| `@import '@carbon/type/scss/*';` | `@use '@carbon/type';`             |
|                                  | `@use '@carbon/styles/scss/type';` |
|                                  | `@use '@carbon/react/scss/type';`  |

**Sass API**

| Filename                              | v10                                  | v11                                      |
| ------------------------------------- | ------------------------------------ | ---------------------------------------- |
| `scss/index.scss`                     |                                      | Removed, use `@carbon/type` directly     |
| `scss/type.scss`                      |                                      | Removed, use `@carbon/type` directly     |
| `scss/_classes.scss`                  | `@mixin carbon--type-classes`        | Renamed to `@mixin type-classes`         |
| `scss/font-face/_mono.scss`           | `@mixin carbon--font-face-mono`      | Removed, use `@carbon/styles/scss/fonts` |
| `scss/font-face/_sans-condensed.scss` | `@mixin carbon--font-face-condensed` | Removed, use `@carbon/styles/scss/fonts` |
| `scss/font-face/_sans.scss`           | `@mixin carbon--font-face-sans`      | Removed, use `@carbon/styles/scss/fonts` |
| `scss/font-face/_serif.scss`          | `@mixin carbon--font-face-serif`     | Removed, use `@carbon/styles/scss/fonts` |
| `scss/font-face/_settings.scss`       | `$carbon--font-display`              | Removed                                  |
| `scss/_font-family.scss`              | `$carbon--font-families`             | Renamed to `$font-families`              |
|                                       | `@function carbon--font-family`      | Renamed to `@function font-family`       |
|                                       | `@mixin carbon--font-family`         | Renamed to `@mixin font-family`          |
|                                       | `$carbon--font-weights`              | Renamed to `$font-weights`               |
|                                       | `@function carbon--font-weight`      | Renamed to `@function font-weight`       |
|                                       | `@mixin carbon--font-weight`         | Renamed to `@mixin font-weight`          |
| `scss/_prefix.scss`                   |                                      | No Changes                               |
| `scss/_reset.scss`                    | `@mixin carbon--default-type`        | Renamed to `@mixin default-type`         |
|                                       | `@mixin carbon--type-reset`          | Renamed to `@mixin type-reset`           |
| `scss/_scale.scss`                    | `@function carbon--get-type-size`    | Removed, use `type-scale` instead        |
|                                       | `$carbon--type-scale`                | Renamed to `$type-scale`                 |
|                                       | `@function carbon--type-scale`       | Renamed to `@function type-scale`        |
|                                       | `@mixin carbon--type-scale`          | Renamed to `@mixin type-scale`           |
|                                       | `@mixin carbon--font-size`           | Renamed to `@mixin font-size`            |
| `scss/_styles.scss`                   | `@mixin carbon--type-style`          | Renamed to `@mixin type-style`           |
|                                       | `$caption-01`                        | Removed                                  |
|                                       | `$caption-02`                        | Removed                                  |

## Type tokens

**Status key:**

- **No change:** Token name has no change between versions.
- **Updated:** This is just a name change, the role remains the same between v10
  and v11.
- **New:** A net new type token to the system in v11. It has no v10 counterpart.
- **Deprecated:** v10 token was removed in v11.

| Category             | V10 token name          | V11 token name     | Status    |
| -------------------- | ----------------------- | ------------------ | --------- |
| Utility styles       | code-01                 | code-01            | No change |
|                      | code-02                 | code-02            | No change |
|                      | label-01                | label-01           | No change |
|                      | label-02                | label-02           | No change |
|                      | helper-text-01          | helper-text-01     | No change |
|                      | helper-text-02          | helper-text-02     | No change |
|                      |                         | legal-01           | New       |
|                      |                         | legal-02           | New       |
|                      | caption-01              |                    | Removed   |
|                      | caption-02              |                    | Removed   |
| Body styles          |                         |                    |           |
|                      | body-short-01           | body-compact-01    | Updated   |
|                      | body-short-02           | body-compact-02    | Updated   |
|                      | body-long-01            | body-01            | Updated   |
|                      | body-long-02            | body-02            | Updated   |
| Fixed heading styles |                         |                    |           |
|                      | productive-heading-01   | heading-compact-01 | Updated   |
|                      | productive-heading-02   | heading-compact-02 | Updated   |
|                      | expressive-heading-01   | heading-01         | Updated   |
|                      | expressive-heading-02   | heading-02         | Updated   |
|                      | productive-heading-03   | heading-03         | Updated   |
|                      | productive-heading-04   | heading-04         | Updated   |
|                      | productive-heading-05   | heading-05         | Updated   |
|                      | productive-heading-06   | heading-06         | Updated   |
|                      | productive-heading-07   | heading-07         | Updated   |
| Fluid heading styles |                         |                    |           |
|                      | expressive-heading-03   | fluid-heading-03   | Updated   |
|                      | expressive-heading-04   | fluid-heading-04   | Updated   |
|                      | expressive-heading-05   | fluid-heading-05   | Updated   |
|                      | expressive-heading-06   | fluid-heading-06   | Updated   |
| Fluid display styles |                         |                    |           |
|                      | expressive-paragraph-01 | fluid-paragraph-01 | Updated   |
|                      | quotation-01            | fluid-quotation-01 | Updated   |
|                      | quotation-02            | fluid-quotation-02 | Updated   |
|                      | display-01              | fluid-display-01   | Updated   |
|                      | display-02              | fluid-display-02   | Updated   |
|                      | display-03              | fluid-display-03   | Updated   |
|                      | display-04              | fluid-display-04   | Updated   |

When applying a fluid token with the `type-style()` mixin, you'll need to pass a
second parameter to indicate it's a fluid token:

```diff
- @include type.type-style('expressive-heading-04');
+ @include type.type-style('fluid-heading-04', true);
```
