# Grid

<!-- prettier-ignore-start -->
<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
## Table of Contents

- [About](#about)
- [Migrating](#migrating)
  - [Breakpoints](#breakpoints)
  - [Columns](#columns)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->
<!-- prettier-ignore-end -->

## About

The minimal grid that was shipped in previous versions of Carbon Components has
now been extracted out into its own packages: `@carbon/grid` and
`@carbon/layout`. Both of these packages are included by default in
`@carbon/elements`.

They are also integrated into `carbon-components` directly so there is no need
to install additional packages if you are using `carbon-components` already.

## Migrating

To include the grid work in `carbon-components`, one would either include the
default `styles.scss` entrypoint or include the grid directly. These imports are
approximately:

```scss
// Global style import
@import 'carbon-components/scss/globals/scss/styles.scss';

// Grid-specific import
@import 'carbon-components/scss/globals/grid/grid';
```

In v10 of Carbon, both of these imports will still work. However, there are some
small differences that you will need to make in order for your grid code to
function properly. Below is a table of the grid-specific variables, functions,
and mixins in order to reference their status in Carbon v10.

| v9                         | v10                                                 |
| -------------------------- | --------------------------------------------------- |
| `$max-width`               | Deprecated, access from `$carbon--grid-breakpoints` |
| `$columns`                 | Deprecated, access from `$carbon--grid-breakpoints` |
| `$grid-breakpoints`        | Replaced with `$carbon--grid-breakpoints`           |
| `$gutter-breakpoints`      | Deprecated                                          |
| `$grid-gutter-breakpoints` | Deprecated                                          |
| `grid` mixin               | Use `carbon--grid` mixin from `@carbon/grid`        |
| `breakpoint` function      | Replaced with `carbon--breakpoint`                  |
| `gutter` function          | Deprecated                                          |
| `grid-gutter` function     | Deprecated                                          |
| `column-size` mixin        | Replaced with `carbon--make-col`                    |

### Breakpoints

The main difference between the v10 version of the grid and earlier versions
will be the breakpoint names. Below is a table showing how they translate into
the new version of the grid:

| v9  | v10     |
| --- | ------- |
| xs  | sm      |
| sm  | md      |
| md  | lg      |
| lg  | xlg     |
| xl  | max     |
| xxl | Removed |

These most likely are being used in your column-specific class names. For
example, the following code snippet contains the `xs` breakpoint:

```html
<div class="bx--col-xs-2"><!-- Content --></div>
```

In the latest version of the grid, the `xs` breakpoint corresponds to the `sm`
breakpoint when referencing the table above. To update this column, you would
need to write the following:

```html
<div class="bx--col-sm-2"><!-- Content --></div>
```

For a complete class reference, see the table below:

| v9                               | v10                                              |
| -------------------------------- | ------------------------------------------------ |
| `bx--grid`                       | No change                                        |
| `bx--row`                        | No change                                        |
| `bx--col-<breakpoint>-<span>`    | Minimal change, replace breakpoint with new name |
| `bx--offset-<breakpoint>-<span>` | Minimal change, replace breakpoint with new name |

### Columns

The default column count in previous versions of the Carbon Design System was
set to 12. In v10, the default column count is still 12. However, the updated
IBM Design Language specifies that layouts should now begin transitioning to a
16 column grid. As a result, we offer a feature flag called `grid-columns-16`
that you can use to enable 16 columns in your grid.

_Note: if using `@carbon/grid` or `@carbon/elements` directly, you will **not**
need to do this_

To enable this in your project, you can specify this feature flag by writing the
following Sass code before importing the grid from `carbon-components`:

```scss
$feature-flags: (
  grid-columns-16: true,
);

// Use one of the following two options to then import the grid code:
// 1) @import 'carbon-components/scss/globals/scss/styles.scss';
// 2) @import 'carbon-components/scss/globals/grid/grid';
```
