# Contributing to Carbon using GitHub Desktop

## Initial Setup

1. Download and install [GitHub Desktop](https://desktop.github.com/)
2. Run the GitHub Desktop application
3. Click the button labeled 'Sign in to Github.com'. This will open your browser
   and take you to an authorization page.
4. Click the 'Authorize desktop' button, which may prompt you for your
   Github.com password
5. You will be asked to configure your Git installation. Set your username and
   email then click the button labeled 'Continue'
6. Agree or disagree to periodic usage stats
7. Navigate to the URL of the repository you'd like to contribute to. For
   example
   [Carbon Design System](https://github.com/carbon-design-system/carbon)
8. In the top right of the page click the button labeled 'Fork'. This will
   create a copy of the repository and add it to your account. This is where
   you'll make changes and later request the repository you forked pull those
   changes from (more on that later).
9. Back in the GitHub Desktop application click the button labeled 'Clone a
   repository from the internet...'
10. In the modal that pops up you can search your account for the fork you made.
    Once you've selected the right repository click the blue button labeled
    'Clone...' in the bottom right corner of the modal.
11. The _next_ modal is a confirmation screen where you can double check the URL
    of your fork and select where on your computer you'd like to clone the
    repository.
12. Once the GitHub Application is done cloning your repository select that you
    intend 'To contribute to the parent project' and then click the button
    labeled 'Continue'. You are now ready to work.

## Basic workflow

1. First things first we need to create a "working" branch. At the top of the
   GitHub Desktop application click the drop down labeled 'Current branch'
2. Click the button labeled 'New branch' and then name your branch. Typically
   this will be a general description of the work you're doing. Maybe
   'updating-accessibility-docs' or 'adding-security-pictograms'. Then click
   'Create branch' to continue
3. Make and save your additions or changes. You should then see your changed
   files in the 'Changes' list on the left and can inspect the exact changes
   line by line on the right
4. Once you've completed your work in the bottom left of the screen you can
   create a summary and description of your commit and then click the button
   labeled 'Commit to (name of your branch)' (tip! use commits like save points
   or check points; you can have as many as you want and they're super helpful
   for rolling back changes since your last commit by clicking the 'Undo' button
   in the bottom left).
5. Once you're finished with your work committed. Click the button on the right
   of the application labeled 'Publish branch'. This will push all your work
   you've done locally to your forked copy of the repository on Github.com.
6. Then click the 'Create Pull Request' button that replaced the previous button
   which will take you to Github.com
7. Here you can fill out the pull request title and template. After you're done
   click 'Create pull request' and you're done!
8. If you want to amend or add more work to your pull request repeat steps 3 and
   4 and then click the button on the right labeled 'Push origin' and your pull
   request will be updated automatically. You can do this for as long as the
   pull request is open.
